/**
 * \file core/mzdata.h
 * \author Olivier Langella
 * \brief collection of spectrum
 */

/*******************************************************************************
* Copyright (c) 2016 Olivier Langella <Olivier.Langella@moulon.inra.fr>.
*
* This file is part of peptider.
*
*     peptider is free software: you can redistribute it and/or modify
*     it under the terms of the GNU General Public License as published by
*     the Free Software Foundation, either version 3 of the License, or
*     (at your option) any later version.
*
*     peptider is distributed in the hope that it will be useful,
*     but WITHOUT ANY WARRANTY; without even the implied warranty of
*     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*     GNU General Public License for more details.
*
*     You should have received a copy of the GNU General Public License
*     along with peptider.  If not, see <http://www.gnu.org/licenses/>.
*
* Contributors:
*     Olivier Langella <Olivier.Langella@moulon.inra.fr> - initial API and implementation
******************************************************************************/

#ifndef MZDATA_H
#define MZDATA_H

#include <QMutex>
#include <pwiz/data/msdata/MSDataFile.hpp>
#include <QFileInfo>
#include <pappsomspp/msrun/msrunid.h>
#include "customspectrum.h"
#include "spectrumdatacollector.h"

class MzData
{
public:
    MzData(const QString & filename, bool mgf=false);
    ~MzData();
    void buildSpectrumCollectorList();
    void addSpectrumDataCollectorSp(SpectrumDataCollectorSp spectrum_data_collector_sp);

    /** \brief tells if all mz data were inspected
     * */
    bool end();

    /** \brief refinePhase2 Physikron
     * */
    void refinePhase2();


    std::vector<SpectrumDataCollectorSp>::const_iterator beginSpectrumDataCollector() const {
        return _spectrum_data_collector_list.begin();
    }

    std::vector<SpectrumDataCollectorSp>::const_iterator endSpectrumDataCollector() const {
        return _spectrum_data_collector_list.end();
    }

    std::vector<SpectrumDataCollectorSp>::iterator beginSpectrumDataCollector() {
        return _spectrum_data_collector_list.begin();
    }

    std::vector<SpectrumDataCollectorSp>::iterator endSpectrumDataCollector() {
        return _spectrum_data_collector_list.end();
    }

    size_t getTotalSpectrumUsed() const;
    size_t getTotalSpectrumNumber()const;
    const QFileInfo & getMzDataFileInfo() const;


private :
    CustomSpectrum getQualifiedSpectrum(size_t scan_index) const;
    void populateSpectrumSpMap();
    void completeSpectrum();
    unsigned int parseScanNumFromTitle(const QString & title) const;

private :

    QFileInfo _file_info;
    pappso::MsRunId _msrun_id;
    pwiz::msdata::MSDataFile * _p_msdata = nullptr;
    pwiz::msdata::SpectrumListPtr _sp_spectrum_list_ptr;
    pwiz::msdata::CVID _native_id_format;

    size_t _total_scan_number=0;
    size_t _current_scan_index = 0;
    size_t _total_spectrum_number=0;

    QMutex _mutex;

    size_t _collector_max_size = 100000;

    std::vector<SpectrumDataCollectorSp> _spectrum_data_collector_list;
    
        
    std::map<const QString, OriginalScan *> _map_title_spectrum_sp; 

};

#endif // MZDATA_H
