
/*******************************************************************************
* Copyright (c) 2016 Olivier Langella <Olivier.Langella@moulon.inra.fr>.
*
* This file is part of peptider.
*
*     peptider is free software: you can redistribute it and/or modify
*     it under the terms of the GNU General Public License as published by
*     the Free Software Foundation, either version 3 of the License, or
*     (at your option) any later version.
*
*     peptider is distributed in the hope that it will be useful,
*     but WITHOUT ANY WARRANTY; without even the implied warranty of
*     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*     GNU General Public License for more details.
*
*     You should have received a copy of the GNU General Public License
*     along with peptider.  If not, see <http://www.gnu.org/licenses/>.
*
* Contributors:
*     Olivier Langella <Olivier.Langella@moulon.inra.fr> - initial API and implementation
******************************************************************************/

#ifndef FASTASOURCE_H
#define FASTASOURCE_H
#include <QString>
#include <pappsomspp/fasta/fastahandlerinterface.h>

#include "mzdata.h"
#include "../reporter/basepsmreporter.h"

class DigestionPipeline;
class DigestProtein;
class DigestProductMatcher;

class FastaSource: public pappso::FastaHandlerInterface {

public:
    FastaSource(BasePsmReporter & reporter);
    ~FastaSource();

    virtual void setSequence(const QString& description, const QString& sequence) override;


    /** \brief scan all fasta proteins against all mz data
     * */
    void scan(MzData * p_mzdata);
    void add(const QFileInfo & fasta_file);

    void addDecoy(const QFileInfo & fasta_decoy_file);
    
    const std::vector<FastaDatabase> & getFastaDatabaseList() const;

private :
    void digestProtein(pappso::ProteinSp & protein_sp);
private:
    BasePsmReporter & _reporter;
    std::vector<FastaDatabase> _fasta_file_list;
    MzData* _p_mzdata;


    DigestProductMatcher * _p_matcher_thread = nullptr;
    pappso::mz _minimum_first_pass_evalue = 0.1;
    size_t _max_protein_list_size = 1000;
    FastaDatabase _current_sequence_database ;
    bool _second_pass = false;
    pappso::pappso_double _second_pass_peptide_evalue_selection;
    size_t _sequence_count = 0;

};

#endif // FASTASOURCE_H
