
/*******************************************************************************
* Copyright (c) 2016 Olivier Langella <Olivier.Langella@moulon.inra.fr>.
*
* This file is part of peptider.
*
*     peptider is free software: you can redistribute it and/or modify
*     it under the terms of the GNU General Public License as published by
*     the Free Software Foundation, either version 3 of the License, or
*     (at your option) any later version.
*
*     peptider is distributed in the hope that it will be useful,
*     but WITHOUT ANY WARRANTY; without even the implied warranty of
*     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*     GNU General Public License for more details.
*
*     You should have received a copy of the GNU General Public License
*     along with peptider.  If not, see <http://www.gnu.org/licenses/>.
*
* Contributors:
*     Olivier Langella <Olivier.Langella@moulon.inra.fr> - initial API and implementation
******************************************************************************/
#ifndef DIGESTPRODUCTMATCHER_H
#define DIGESTPRODUCTMATCHER_H

#include <QRunnable>
#include <QMutex>
#include "mzdata.h"
#include "fastasource.h"
#include "digestionpipeline.h"
#include <pappsomspp/protein/enzymeproductinterface.h>

class DigestProductMatcher: public QRunnable, public pappso::PeptideModificatorInterface
{
public:
    DigestProductMatcher(MzData * p_mzdata, bool first);
    ~DigestProductMatcher();

    virtual void run() override;

    std::size_t size() const;
    void push_back_protein_to_digest(const FastaDatabase & _fasta_database, const QString & description, const QString & sequence);
    virtual void setPeptideSp(std::int8_t sequence_database_id, const pappso::ProteinSp& protein_sp, bool is_decoy, const pappso::PeptideSp& peptide_sp,  unsigned int start, bool is_nter, unsigned int missed_cleavage_number, bool semi_enzyme) override;
    const DigestionPipelineBase * getDigestionPipeline() const;

    void pushBackProteinSecondPass(std::int8_t sequence_database_id, pappso::ProteinSp protein_sp, bool reverse);
    std::size_t secondPassSize() const;

private:

    struct ProteinsString {
        FastaDatabase _fasta_database;
        QString _description;
        QString _sequence;
    };
    struct ProteinDb {
        std::int8_t _database_id;
        const pappso::ProteinSp _p_protein_sp;
        bool _reverse;
    };

    /** \brief first or second pass
       * */
    bool _first;
    DigestionPipelineBase * _p_digestion_pipeline = nullptr;
    /** \brief suffix tag to add when reversing sequence
     * */
    QString _decoy_accession_suffix_tag;


    unsigned int _maximum_peptide_charge;

    /** \brief compute reverse protein sequence (decoy)
     */
    bool _compute_reverse = true;

    std::vector<DigestProductMatcher::ProteinsString> _protein_list;
    std::vector<DigestProduct> _product_list;
    std::vector<DigestProductMatcher::ProteinDb> _protein_list_second_pass;
    MzData * _p_mzdata;

    pappso::mz _minimum_mz =150;
    pappso::mz _maximum_mz = 1500;
};

#endif // DIGESTPRODUCTMATCHER_H
