/**
 * \file core/digestionpipelinesecondpass.h
 * \date 1/12/2016
 * \author Olivier Langella
 * \brief digestion pipeline for the second identification pass
 */

/*******************************************************************************
* Copyright (c) 2016 Olivier Langella <Olivier.Langella@moulon.inra.fr>.
*
* This file is part of peptider.
*
*     peptider is free software: you can redistribute it and/or modify
*     it under the terms of the GNU General Public License as published by
*     the Free Software Foundation, either version 3 of the License, or
*     (at your option) any later version.
*
*     peptider is distributed in the hope that it will be useful,
*     but WITHOUT ANY WARRANTY; without even the implied warranty of
*     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*     GNU General Public License for more details.
*
*     You should have received a copy of the GNU General Public License
*     along with peptider.  If not, see <http://www.gnu.org/licenses/>.
*
* Contributors:
*     Olivier Langella <Olivier.Langella@moulon.inra.fr> - initial API and implementation
******************************************************************************/

#ifndef DIGESTIONPIPELINESECONDPASS_H
#define DIGESTIONPIPELINESECONDPASS_H

#include "digestionpipeline.h"
#include <pappsomspp/protein/peptidesemienzyme.h>
#include <unordered_set>

class DigestionPipelineSecondPass: public pappso::PeptideModificatorInterface, public DigestionPipelineBase
{
public:
    DigestionPipelineSecondPass(pappso::PeptideModificatorInterface * digestion_sink);
    ~DigestionPipelineSecondPass();
    void eat(std::int8_t sequence_database_id, const pappso::ProteinSp & protein_sp, bool is_decoy) override;

    virtual void setPeptideSp(std::int8_t sequence_database_id, const pappso::ProteinSp& protein_sp, bool is_decoy, const pappso::PeptideSp& peptide_sp,  unsigned int start, bool is_nter, unsigned int missed_cleavage_number, bool semi_enzyme) override;

private :

    bool _semi_enzymatic_digestion = true;

    pappso::PeptideModificatorInterface * _digestion_sink;
    bool _compute_first_pass_products;
    unsigned int _maximum_peptide_charge = 3;
    unsigned int _2d_pass_maximum_number_of_missed_cleavage = 1;
    pappso::mz _minimum_mz =150;
    pappso::mz _maximum_mz = 1500;

    std::hash<std::string> _hash_fn;
    std::unordered_set<size_t> _first_pass_product;
    DigestionPipeline* _p_digestion_pipeline_first_pass = nullptr;
    pappso::PeptideSemiEnzyme* _p_semi_peptide_digestion = nullptr;
};

#endif // DIGESTIONPIPELINESECONDPASS_H
