/**
 * \file utils/pwizutils.h
 * \author Olivier Langella
 * \brief wrappers to handle Pwiz data
 */

/*******************************************************************************
* Copyright (c) 2017 Olivier Langella <olivier.langella@u-psud.fr>.
*
* This file is part of phase2.
*
*     phase2 is free software: you can redistribute it and/or modify
*     it under the terms of the GNU General Public License as published by
*     the Free Software Foundation, either version 3 of the License, or
*     (at your option) any later version.
*
*     phase2 is distributed in the hope that it will be useful,
*     but WITHOUT ANY WARRANTY; without even the implied warranty of
*     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*     GNU General Public License for more details.
*
*     You should have received a copy of the GNU General Public License
*     along with phase2.  If not, see <http://www.gnu.org/licenses/>.
*
* Contributors:
*     Olivier Langella <olivier.langella@u-psud.fr> - initial API and implementation
******************************************************************************/

#ifndef PWIZUTILS_H
#define PWIZUTILS_H

#include <QString>
#include <pwiz/data/msdata/MSDataFile.hpp>

pwiz::msdata::MSDataFile * getPwizMSDataFile(const QString & filename,bool mgf=false);

void writePwizMsdata(pwiz::msdata::MSData * p_msdata, const QString & mz_filename);

void writePwizMsdataInMgfFile(pwiz::msdata::MSDataFile * p_msdata, const QString & mgf_filename);

void copyParamContainer(const pwiz::data::ParamContainer * old_container,pwiz::data::ParamContainer * new_container);
void copySpectrumListPtr(const pwiz::msdata::MSData * p_new_pwiz_data, const pwiz::msdata::SpectrumList * old_spectrum_list, pwiz::msdata::SpectrumListSimple * new_spectrum_list);
void copySpectrum(const pwiz::msdata::MSData * p_new_pwiz_data, pwiz::msdata::CVID old_native_id_format, const pwiz::msdata::Spectrum * old_spectrum_p, pwiz::msdata::CVID new_native_id_format, pwiz::msdata::Spectrum * new_spectrum_p);
void copyInstrumentConfiguration(const pwiz::msdata::InstrumentConfiguration * old_instrument, pwiz::msdata::InstrumentConfiguration * new_instrument);
void copySoftware(const pwiz::msdata::Software * old_software, pwiz::msdata::Software * new_software);

#endif // PWIZUTILS_H
