/**
 * \file utils/peptidestore.h
 * \date 7/10/2016
 * \author Olivier Langella
 * \brief store unique version of peptides
 */

/*******************************************************************************
 * Copyright (c) 2016 Olivier Langella <Olivier.Langella@moulon.inra.fr>.
 *
 * This file is part of peptider.
 *
 *     peptider is free software: you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation, either version 3 of the License, or
 *     (at your option) any later version.
 *
 *     peptider is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with peptider.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Contributors:
 *     Olivier Langella <Olivier.Langella@moulon.inra.fr> - initial API and implementation
 ******************************************************************************/

#ifndef PEPTIDESTORE_H
#define PEPTIDESTORE_H

#include <pappsomspp/peptide/peptide.h>
#include <unordered_map>

class PeptideStore
{
public:
    PeptideStore();
    ~PeptideStore();

    pappso::PeptideSp & getInstance(pappso::PeptideSp & peptide_in);

private :
  
    std::hash<std::string> _hash_fn;
    std::unordered_map<std::size_t, pappso::PeptideSp> _map_crc_peptide_list;
};

#endif // PEPTIDESTORE_H
