/**
 * \file utils/peptidestore.h
 * \date 7/10/2016
 * \author Olivier Langella
 * \brief store unique version of peptides
 */

/*******************************************************************************
 * Copyright (c) 2016 Olivier Langella <Olivier.Langella@moulon.inra.fr>.
 *
 * This file is part of peptider.
 *
 *     peptider is free software: you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation, either version 3 of the License, or
 *     (at your option) any later version.
 *
 *     peptider is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with peptider.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Contributors:
 *     Olivier Langella <Olivier.Langella@moulon.inra.fr> - initial API and implementation
 ******************************************************************************/

#include "peptidestore.h"

PeptideStore::PeptideStore()
{

}

PeptideStore::~PeptideStore()
{

}

pappso::PeptideSp & PeptideStore::getInstance(pappso::PeptideSp & peptide_in) {
    std::size_t sequence_li_crc = _hash_fn ( peptide_in.get()->getLiAbsoluteString().toStdString());

    //QByteArray source = peptide_in.get()->getLiAbsoluteString().toUtf8();
    //quint16 sequence_li_crc = qChecksum(source.data(), source.length());

    std::pair<std::unordered_map< std::size_t, pappso::PeptideSp>::iterator,bool> ret = _map_crc_peptide_list.insert(std::pair<std::size_t, pappso::PeptideSp>(sequence_li_crc,peptide_in));
    
    return ret.first->second;

}
