/**
 * \file utils/hardklorwrapper.h
 * \author Olivier Langella
 * \brief wrappers to handle Hardklor
 */

/*******************************************************************************
* Copyright (c) 2017 Olivier Langella <olivier.langella@u-psud.fr>.
*
* This file is part of phase2.
*
*     phase2 is free software: you can redistribute it and/or modify
*     it under the terms of the GNU General Public License as published by
*     the Free Software Foundation, either version 3 of the License, or
*     (at your option) any later version.
*
*     phase2 is distributed in the hope that it will be useful,
*     but WITHOUT ANY WARRANTY; without even the implied warranty of
*     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*     GNU General Public License for more details.
*
*     You should have received a copy of the GNU General Public License
*     along with phase2.  If not, see <http://www.gnu.org/licenses/>.
*
* Contributors:
*     Olivier Langella <olivier.langella@u-psud.fr> - initial API and implementation
******************************************************************************/

#ifndef HARDKLORWRAPPER_H
#define HARDKLORWRAPPER_H
#include <QString>

class HardKlorWrapper
{
public:
    HardKlorWrapper(const QString & hardklor_exe);
    void setResolution(double resolution);
    void setWindowDalton(double resolution);
    void setCorrelation(double correlation);
    void setInstrument(const QString & instrument);
    
    void run202 (const QString & mzfile, const QString & output_xml);
    void run (const QString & mzfile, const QString & output_xml);
    void transformXmlOutputToText(const QString & input_xml, const QString & output_txt);
private:
    const QString _hardklor_exe;
    double _resolution=70000;
    double _window_dalton=3;
    double _correlation=0.925;
    unsigned int _minimum_scan_range=150; //ignore any spectra lower than this number, 0=off
    QString _instrument= "FTICR"; //Values are: FTICR, Orbitrap, TOF, QIT
    int _max_hk_time_ms = (60000 * 60); //1 hour
    QString _hardklor_data;
    QString _isotope_data;
};

#endif // HARDKLORWRAPPER_H
