/**
 * \file reporter/odspsmreporter.h
 * \date 11/9/2016
 * \author Olivier Langella
 * \brief ODS psm reporter
 */

/*******************************************************************************
* Copyright (c) 2016 Olivier Langella <Olivier.Langella@moulon.inra.fr>.
*
* This file is part of peptider.
*
*     peptider is free software: you can redistribute it and/or modify
*     it under the terms of the GNU General Public License as published by
*     the Free Software Foundation, either version 3 of the License, or
*     (at your option) any later version.
*
*     peptider is distributed in the hope that it will be useful,
*     but WITHOUT ANY WARRANTY; without even the implied warranty of
*     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*     GNU General Public License for more details.
*
*     You should have received a copy of the GNU General Public License
*     along with peptider.  If not, see <http://www.gnu.org/licenses/>.
*
* Contributors:
*     Olivier Langella <Olivier.Langella@moulon.inra.fr> - initial API and implementation
******************************************************************************/
#ifndef ODSPSMREPORTER_H
#define ODSPSMREPORTER_H

#include "basepsmreporter.h"
#include <odsstream/calcwriterinterface.h>
#include <set>
#include <pappsomspp/spectrum/spectrum.h>


#include "../core/mzdata.h"

class OdsPsmReporter: public BasePsmReporter
{
public:
    OdsPsmReporter(CalcWriterInterface & writer);
    ~OdsPsmReporter();

    virtual void writeResults(const MzData * p_mzdata) override;
    virtual void close() override;
    
    void addDebugScanIndex(unsigned int scan_index) ;
    
protected:


private :
    virtual void write(const SpectrumDataCollector & spectrum);
    
    CalcWriterInterface & _writer;
    const SpectrumDataCollector * _p_last_spectrum = nullptr;
    std::set<unsigned int> _identified_spectrum_list;
    
    /** \brief list of scan numbers to write debugging infos
     */ 
    std::vector <unsigned int> _debug_scan_list;
    
    /** \brief number of identified peptides
     */
    std::vector<const pappso::Peptide *> _p_peptide_list;
    /** \brief number of identified peptides on a decoy database
     */
    std::vector<const pappso::Peptide *> _p_peptide_list_decoy;

};

#endif // ODSPSMREPORTER_H
