/**
 * \file reporter/mzidentmlreporter.h
 * \date 5/10/2016
 * \author Olivier Langella
 * \brief mzIdentML writer
 */

/*******************************************************************************
* Copyright (c) 2016 Olivier Langella <Olivier.Langella@moulon.inra.fr>.
*
* This file is part of peptider.
*
*     peptider is free software: you can redistribute it and/or modify
*     it under the terms of the GNU General Public License as published by
*     the Free Software Foundation, either version 3 of the License, or
*     (at your option) any later version.
*
*     peptider is distributed in the hope that it will be useful,
*     but WITHOUT ANY WARRANTY; without even the implied warranty of
*     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*     GNU General Public License for more details.
*
*     You should have received a copy of the GNU General Public License
*     along with peptider.  If not, see <http://www.gnu.org/licenses/>.
*
* Contributors:
*     Olivier Langella <Olivier.Langella@moulon.inra.fr> - initial API and implementation
******************************************************************************/

#ifndef __MZIDENTMLREPORTER_H__
#define __MZIDENTMLREPORTER_H__

#include "basepsmreporter.h"
#include <QXmlStreamWriter>
#include <QFile>
#include <QString>
#include <pappsomspp/protein/protein.h>
#include "../core/mzdata.h"

class MzIdentMlReporter : public BasePsmReporter
{
public:
    MzIdentMlReporter(const QString & out_filename);
    ~MzIdentMlReporter();

    virtual void writeResults(const MzData * p_mzdata) override;
    virtual void close() override;


private :
    void writeSequenceCollection();
    void writePeptideModifications(const pappso::Aa & aa, unsigned int position);

    void writeAnalysisCollection();
    void writeAnalysisProtocolCollection();
    void writeCvParam(const QString & accession,const QString & cv_ref,const QString & name);
    void writeCvParam(const QString & accession,const QString & cv_ref,const QString & value, const QString & name);
    void writeCvParamUo(const QString & cv_ref, const QString & accession,const QString & name, const QString & value, const QString & unit_accession, const QString & unit_name);
    void writeInputs();
    void writeFragmentationTable();
    void writeSpectrumIdentificationResultList();
    void writeSpectrumIdentificationResult(SpectrumDataCollectorSp spectrum);
    QString getXmlFloat(pappso::pappso_double number);
private :
    //const DigestionPipeline * _p_digestion_pipeline;
    unsigned int _sir_num=0;
    const MzData * _p_mzdata;
    char _format = 'g';
    int _precision = 10;
    QFile * _output_file;
    QXmlStreamWriter * _output_stream;
    QString _mzidentml;
    QString _mz_filename;

    struct ProteinDb {
        const pappso::Protein * _p_protein;
        std::int8_t _database_id;
	bool _reverse;
        bool operator==(const ProteinDb& rhs) {
            return (_p_protein == rhs._p_protein);
        }
        bool operator<(const ProteinDb& rhs) {
            return (_p_protein < rhs._p_protein);
        }
    };
    std::vector<MzIdentMlReporter::ProteinDb> _p_protein_list;
    std::vector<const pappso::Peptide *> _p_peptide_list;

    std::map<const pappso::Protein *, QString> _map_protein_xmlid;
    std::map<const pappso::Peptide *, QString> _map_peptide_xmlid;
    std::map<QString, QString> _map_peptide_evidence_xmlid;
};

#endif /* __MZIDENTMLREPORTER_H__ */
