/**
 * \file reporter/basepsmreporter.cpp
 * \date 10/9/2016
 * \author Olivier Langella
 * \brief base interface to report identification results
 */

/*******************************************************************************
* Copyright (c) 2016 Olivier Langella <Olivier.Langella@moulon.inra.fr>.
*
* This file is part of peptider.
*
*     peptider is free software: you can redistribute it and/or modify
*     it under the terms of the GNU General Public License as published by
*     the Free Software Foundation, either version 3 of the License, or
*     (at your option) any later version.
*
*     peptider is distributed in the hope that it will be useful,
*     but WITHOUT ANY WARRANTY; without even the implied warranty of
*     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*     GNU General Public License for more details.
*
*     You should have received a copy of the GNU General Public License
*     along with peptider.  If not, see <http://www.gnu.org/licenses/>.
*
* Contributors:
*     Olivier Langella <Olivier.Langella@moulon.inra.fr> - initial API and implementation
******************************************************************************/
#include "basepsmreporter.h"

#include "../core/digestionpipeline.h"

BasePsmReporter::BasePsmReporter()
{
    _p_digestion_pipeline = new DigestionPipeline(nullptr);
}

BasePsmReporter::~BasePsmReporter()
{
    delete _p_digestion_pipeline;
}

void BasePsmReporter::setFastaDatabaseList(std::vector< FastaDatabase > fasta_file_list) {
    _fasta_file_list = fasta_file_list;
}


std::vector<PsmScore> BasePsmReporter::getPsmScoreList(const SpectrumDataCollector & spectrum) const {
//QTextStream errorStream(stderr, QIODevice::WriteOnly);


    std::vector<PsmScore> result_list = spectrum.getPsmScoreList();

    std::sort(result_list.begin(), result_list.end(),
    [](const PsmScore & a, const PsmScore & b) {
        return (a.hyperscore < b.hyperscore);
    });


    return result_list;
}

