/**
 * \file phase2.h
 * \author Olivier Langella
 * \brief main program
 */

/*******************************************************************************
* Copyright (c) 2017 Olivier Langella <olivier.langella@u-psud.fr>.
*
* This file is part of phase2.
*
*     phase2 is free software: you can redistribute it and/or modify
*     it under the terms of the GNU General Public License as published by
*     the Free Software Foundation, either version 3 of the License, or
*     (at your option) any later version.
*
*     phase2 is distributed in the hope that it will be useful,
*     but WITHOUT ANY WARRANTY; without even the implied warranty of
*     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*     GNU General Public License for more details.
*
*     You should have received a copy of the GNU General Public License
*     along with phase2.  If not, see <http://www.gnu.org/licenses/>.
*
* Contributors:
*     Olivier Langella <olivier.langella@u-psud.fr> - initial API and implementation
******************************************************************************/

#ifndef PHASE2_H
#define PHASE2_H

#include <QDebug>

#include <QObject>
#include <QCoreApplication>
#include <QTemporaryFile>
#include "config.h"

class Phase2: public QObject
{
    Q_OBJECT

private:
    QCoreApplication *app;

public:

    void windaube_exit();

    explicit Phase2(QObject *parent = 0);
    /////////////////////////////////////////////////////////////
    /// Call this to quit application
    /////////////////////////////////////////////////////////////
    void quit();

signals:
    /////////////////////////////////////////////////////////////
    /// Signal to finish, this is connected to Application Quit
    /////////////////////////////////////////////////////////////
    void finished();

public slots:
    /////////////////////////////////////////////////////////////
    /// This is the slot that gets called from main to start everything
    /// but, everthing is set up in the Constructor
    /////////////////////////////////////////////////////////////
    void run();

    /////////////////////////////////////////////////////////////
    /// slot that get signal when that application is about to quit
    /////////////////////////////////////////////////////////////
    void aboutToQuitApp();
    
private :
    void translateMz2Mgf(const QString & mz_file_str);
    void findMzPrecursors(const QString & mz_file_str);
    void runPhase1();
    
    
private:
    QTemporaryFile _mgf_temp_orig_file;
    QTemporaryFile _mgf_temp_phase1_output_file;
    QTemporaryFile _hk_temp_xml_file;
    QTemporaryFile _hk_temp_txt_file;
};

#endif // PHASE2_H
