/**
 * \file core/secondpass.cpp
 * \date 1/12/2016
 * \author Olivier Langella
 * \brief digestion pipeline for the second identification pass
 */

/*******************************************************************************
* Copyright (c) 2016 Olivier Langella <Olivier.Langella@moulon.inra.fr>.
*
* This file is part of peptider.
*
*     peptider is free software: you can redistribute it and/or modify
*     it under the terms of the GNU General Public License as published by
*     the Free Software Foundation, either version 3 of the License, or
*     (at your option) any later version.
*
*     peptider is distributed in the hope that it will be useful,
*     but WITHOUT ANY WARRANTY; without even the implied warranty of
*     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*     GNU General Public License for more details.
*
*     You should have received a copy of the GNU General Public License
*     along with peptider.  If not, see <http://www.gnu.org/licenses/>.
*
* Contributors:
*     Olivier Langella <Olivier.Langella@moulon.inra.fr> - initial API and implementation
******************************************************************************/
#include "secondpass.h"
#include <algorithm>

SecondPass::SecondPass(MzData * p_mzdata)
{

    std::vector<SpectrumDataCollectorSp>::const_iterator it = p_mzdata->beginSpectrumDataCollector();

    std::vector<SpectrumDataCollectorSp>::const_iterator itend = p_mzdata->endSpectrumDataCollector();

// 	PeptideStore peptide_store;

    while (it != itend) {
        //spectrum->print(_reporter);
        std::vector<PsmScore> result_list = it->get()->getPsmScoreList();
        for (PsmScore & score: result_list) {

            _p_protein_list.push_back( {score.digest_product.protein_sp.get(),score.digest_product.sequence_database_id, score.digest_product.reverse });

        }
        it++;
    }
    std::sort(_p_protein_list.begin(), _p_protein_list.end());
    _p_protein_list.erase(std::unique(_p_protein_list.begin(), _p_protein_list.end()), _p_protein_list.end());
    
    
    
}

SecondPass::~SecondPass()
{

}
