import xml.sax
from mzxml_scan import mzxml_scan
import sqlite3

class mzXMLHandler(xml.sax.ContentHandler): 
	in_ms2 = False
	scan = None
	scan_list = None
	pmz = ""
	_charBuffer = []
	
	def set_export(self, export, sample_name):
		self.export = export
		self.sample_name = sample_name
		
	def characters(self, data):
		self._charBuffer.append(data)
		
	def _getCharacterData(self):
		data = ''.join(self._charBuffer).strip()
		return data.strip() #remove strip() if whitespace is important	
	
	def startElement(self, name, attrs):
		num = ""
		mslevel = ""
		rt = ""
		bpi = ""
		bpimz = ""
		if name =="scan":
			for (k,v) in attrs.items():
				if k == "num":
					num = v
				elif k == "msLevel":
					mslevel = v
				elif k == "retentionTime":
					rt = v[2:-1]
				elif k == "basePeakIntensity":
					bpi = v
				elif k == "totIonCurrent":
					tic = v
				elif k == "basePeakMz":
					bpimz = v
			self.scan = mzxml_scan(num)
			self.scan.set_scan_info(mslevel, rt, bpi, tic, bpimz)
			#print "the scan "+str(num)+" is a level "+str(mslevel)
		elif name == "precursorMz":
			pscannum = ""
			pintensity = ""
			pcharge = ""
			pmz = ""
			for (k,v) in attrs.items():
				if k == "precursorScanNum":
					pscannum = v
				elif k == "precursorIntensity":
					pintensity = v
				elif k == "precursorCharge":
					pcharge = v
				
			self.scan.set_precursor_scan_info(pscannum, 0.0, pintensity, pcharge)

	def endElement(self, name):
		if name =="scan":
			#self.db.add_scan(self.sample_name, self.scan)
			self.scan.set_sample_name(self.sample_name)
			self.export.append(self.scan)
			self.scan = None
		elif name =="precursorMz":
			self.pmz = self._getCharacterData()
			self.scan.set_precursor_mz(self.pmz)
		self._charBuffer = []
			
		
