from PyQt5 import QtGui, QtCore, QtWidgets
import math

class InformationTab(QtWidgets.QTableWidget):

	def __init__(self,parent):
		super(InformationTab, self).__init__(parent)
		self.setFixedHeight(85)
		self.setMinimumWidth(650)
		self.setColumnCount(7)
		self.setRowCount(2)
		self.horizontalHeader().hide()
		self.verticalHeader().hide()
		self.setItem(0, 1, QtWidgets.QTableWidgetItem("MS1 count"))
		self.setItem(0, 2, QtWidgets.QTableWidgetItem("MS2 count"))
		self.setItem(0, 3, QtWidgets.QTableWidgetItem("MS1 intensity(basepeak)"))
		self.setItem(0, 4, QtWidgets.QTableWidgetItem("MS2 intensity(basepeak)"))
		self.setItem(0, 5, QtWidgets.QTableWidgetItem("MS1  intensity(tic)"))
		self.setItem(0, 6, QtWidgets.QTableWidgetItem("MS2  intensity(tic)"))
		self.setItem(0, 6, QtWidgets.QTableWidgetItem("Maximum cycle duration"))
		# self.setItem(2, 1, QtGui.QTableWidgetItem("Nb MS2 utilise"))
		# self.setItem(2, 2, QtGui.QTableWidgetItem("Nb MS2 assigne"))
		# self.setItem(2, 3, QtGui.QTableWidgetItem("Nb peptide unique"))
		self.verticalHeader().setDefaultSectionSize(20)

	def add_msdata_info(self, data_info):
		self.setItem(1, 0, QtWidgets.QTableWidgetItem("msdata"))
		self.setItem(1, 1, QtWidgets.QTableWidgetItem(str(data_info['nb_ms1'])))
		self.setItem(1, 2, QtWidgets.QTableWidgetItem(str(data_info['nb_ms2'])))
		self.setItem(1, 3, QtWidgets.QTableWidgetItem(str(math.log10(data_info['intensity_ms1']))))
		self.setItem(1, 4, QtWidgets.QTableWidgetItem(str(math.log10(data_info['intensity_ms2']))))
		self.setItem(1, 5, QtWidgets.QTableWidgetItem(str(math.log10(data_info['tic_ms1']))))
		self.setItem(1, 6, QtWidgets.QTableWidgetItem(str(math.log10(data_info['tic_ms2']))))
		self.setItem(1, 6, QtWidgets.QTableWidgetItem(str(data_info['max_cycle'])))
		self.show()

	def cleanTab(self):
		self.hide()
