﻿# -*- coding: utf-8 -*-

from PyQt5 import QtGui, QtCore, QtWidgets
import sys
import os
import xml.sax
#import psutil
from math import log10
from time import sleep

###Class Personnel interface
from SampleTree import SampleTree
from InformationTab import InformationTab
from CheckBoxTree import CheckBoxTree
from SummarizeTree import SummarizeTree
from LoaderInformation import LoaderInformation
###class Personnel parser
from msdata import MsData
from mzxml_scan import mzxml_scan
from Parser.mzXMLHandler import mzXMLHandler
from Parser.mzMLHandler import mzMLHandler
from FileQLoader import FileQLoader
from Parser.SampleOrder import SampleOrder
import util_qt
import version

class MainWindow(QtWidgets.QMainWindow):
	def __init__(self):
		super(MainWindow, self).__init__()
		self.initUI()
		self.msdata = None
		self.isMsdataSet = False

	def initUI(self):
		self.setMinimumSize(1200, 700)
		self.setWindowTitle("MS-Eater version : "+version.MSEATER_VERSION)
		self.MainWidget = QtWidgets.QWidget(self)
		self.MainWidget.setGeometry(0, 15, 1180, 680)
		self.initMenu()
		self.mainlayout = QtWidgets.QGridLayout(self.MainWidget)
		self.MainWidget.setLayout(self.mainlayout)
		self.tree = SampleTree(self)
		self.mainlayout.addWidget(self.tree, 0,0, 3, 1)
		self.samplename = QtWidgets.QTextEdit(self.MainWidget)
		self.samplename.setReadOnly(True)
		self.samplename.setFontPointSize(12.0)
		self.samplename.setFixedHeight(30)
		self.samplename.setMinimumWidth(650)
		self.mainlayout.addWidget(self.samplename, 0, 1)
		self.Information = InformationTab(self.MainWidget)
		self.mainlayout.addWidget(self.Information, 1, 1)
		self.GraphWidget = QtWidgets.QWidget(self.MainWidget)
		self.GraphWidget.setMinimumSize(650, 480)
		self.graphlayout = QtWidgets.QVBoxLayout()
		self.GraphWidget.setLayout(self.graphlayout)
		self.mainlayout.addWidget(self.GraphWidget, 2, 1)
		self.statusBar().showMessage('Bonjour')
		self.Information.hide()
		self.tree.show()
		self.orderLoaded  = False
		self.show()

	def initMenu(self):
		#### File menu
		self.exitAction = QtWidgets.QAction(QtGui.QIcon('exit.png'), '&Exit', self)
		self.exitAction.setShortcut('Ctrl+Q')
		self.exitAction.setStatusTip('Exit application')
		self.exitAction.triggered.connect(QtWidgets.qApp.quit)
		self.loadDirAction = QtWidgets.QAction(QtGui.QIcon('load.png'), '&Load msdata from directory', self)
		self.loadDirAction.setShortcut('Ctrl+O')
		self.loadDirAction.triggered.connect(self.selectMsdataDirectory)
		self.loadFileAction = QtWidgets.QAction(QtGui.QIcon('load.png'), '&Load msdata', self)
		self.loadFileAction.setShortcut('Ctrl+O')
		self.loadFileAction.triggered.connect(self.selectMsdataFiles)
		self.loadSequenceAction = QtWidgets.QAction(QtGui.QIcon('load.png'), '&Load sequence file', self)
		self.loadSequenceAction.triggered.connect(self.selectMsSequenceFile)
		self.loadProjectAction = QtWidgets.QAction(QtGui.QIcon('load.png'), '&Load project', self)
		self.loadProjectAction.triggered.connect(self.loadProject)
		# self.loadSampleOrderAction = QtGui.QAction(QtGui.QIcon('load.png'), '&Load Sample Order', self)
		# self.loadSampleOrderAction.triggered.connect(self.loadSampleOrder)
		self.saveProjectAction = QtWidgets.QAction(QtGui.QIcon('load.png'), '&Save project', self)
		self.saveProjectAction.triggered.connect(self.saveProject)
		self.deleteDataAction = QtWidgets.QAction(QtGui.QIcon('load.png'), '&Delete data', self)
		self.deleteDataAction.triggered.connect(self.clearData)
		#### export menu
		self.exportbilanAction = QtWidgets.QAction(QtGui.QIcon('load.png'), '&export bilan', self)
		self.exportbilanAction.triggered.connect(self.exportbilan)
		# self.exportSampleNameAction = QtGui.QAction(QtGui.QIcon('load.png'), '&export Sample Name', self)
		# self.exportSampleNameAction.triggered.connect(self.export_samplenames)
		#### view menu
		self.multiMS1ViewAction = QtWidgets.QAction(QtGui.QIcon('load.png'), '&View combined MS1', self)
		self.multiMS1ViewAction.triggered.connect(self.multiMS1View)
		self.viewBySampleAction = QtWidgets.QAction(QtGui.QIcon('load.png'), '&View by Sample', self)
		self.viewBySampleAction.triggered.connect(self.viewBySample)
		self.viewOrderedResumeAction = QtWidgets.QAction(QtGui.QIcon('load.png'), '&View Summary', self)
		self.viewOrderedResumeAction.triggered.connect(self.viewOrderedResume)

		menubar = self.menuBar()
		fileMenu = menubar.addMenu('&File')
		fileMenu.addAction(self.loadDirAction)
		fileMenu.addAction(self.loadFileAction)
		fileMenu.addAction(self.loadProjectAction)
		fileMenu.addAction(self.loadSequenceAction)
		# fileMenu.addAction(self.loadSampleOrderAction)
		fileMenu.addAction(self.saveProjectAction)
		fileMenu.addAction(self.deleteDataAction)
		fileMenu.addAction(self.exitAction)
		visuMenu = menubar.addMenu('&View')
		visuMenu.addAction(self.viewBySampleAction)
		visuMenu.addAction(self.multiMS1ViewAction)
		visuMenu.addAction(self.viewOrderedResumeAction)
		exportMenu = menubar.addMenu('&Export')
		exportMenu.addAction(self.exportbilanAction)
		# exportMenu.addAction(self.exportSampleNameAction)

	def selectMsdataDirectory(self):
		print("loadingfiles")
		directory = str(QtWidgets.QFileDialog.getExistingDirectory(self, 'Select a directory'))
		list_file = os.listdir(directory)
		to_parse = []
		for filename in list_file:
			if os.path.isfile(os.path.join(directory, filename)):
				extension = os.path.splitext(os.path.join(directory, filename))[1]
				if extension == '.mzXML':
					print(filename+" a parser")
					to_parse.append(os.path.join(directory, filename))
				elif extension == '.mzML':
					print(filename+" a parser")
					to_parse.append(os.path.join(directory, filename))
				else:
					print(filename+" n'est pas un fichier msdata")
			else:
				print(filename+" n'est pas un fichier")
		if len(to_parse) != 0:
			self.loadMsdata(to_parse)

	def selectMsdataFiles(self):
		print("loadingfiles")
		files = QtWidgets.QFileDialog.getOpenFileNames(self, 'Select Files')[0]
		print(files)
		to_parse = []
		for file in files:
			print(file)
			if os.path.isfile(file):
				extension = os.path.splitext(str(file))[1]
				if extension == '.mzXML':
					print(file+" a parser")
					to_parse.append(file)
				elif extension == '.mzML':
					print(file+" a parser")
					to_parse.append(file)
				else:
					print(file+" n'est pas un fichier msdata")
			else:
				print(file+" n'est pas un fichier")
		if len(to_parse) != 0:
			self.loadMsdata(to_parse)

	def selectMsSequenceFile(self):
		print("loading sequence files")
		file = QtWidgets.QFileDialog.getOpenFileName(self, 'Select a Sequences Files')
		orderfile = SampleOrder(file)
		samples = orderfile.getSamples()
		self.skip = False
		to_parse = []
		while len(samples.keys()) != 0 and  not self.skip:
			directory = str(QtWidgets.QFileDialog.getExistingDirectory(self, 'Select a directory'))
			list_file = os.listdir(directory)

			print(samples.keys())
			for filename in list_file:
				#print os.path.splitext(unicode(filename))[0]
				if os.path.isfile(os.path.join(directory, filename)):
					if os.path.splitext(str(filename))[0] in samples.keys():
						#print os.path.splitext(unicode(filename))[0]+unicode(" Found")
						if os.path.splitext(str(filename))[1] == ".mzXML":
							samples[os.path.splitext(str(filename))[0]]["currentLocation"] = os.path.join(directory, filename)
							to_parse.append(samples[os.path.splitext(str(filename))[0]])
							samples.pop(os.path.splitext(str(filename))[0])
			self.nbFileFound = LoaderInformation(self, 0, "Summary of sequence loading", progressbar = False)
			self.nbFileFound.show()
			self.nbFileFound.topLevelWidget()
			self.nbFileFound.addInfo("Number of samples in sequence file : "+str(len(samples.keys())+len(to_parse)))
			self.nbFileFound.addInfo("Number of files found : "+str(len(to_parse)))
			if len(samples.keys()) ==0:
				self.nbFileFound.addInfo("All samples found")
				self.nbFileFound.addCloseButton()
			else:
				self.nbFileFound.addInfo("Missing samples")
				for key in samples.keys():
					self.nbFileFound.addInfo(key)
				self.nbFileFound.addYesButton("Add another directory")
				self.nbFileFound.addNoButton("cancel")
				self.connect(self.nbFileFound, QtCore.SIGNAL("skip file"), self.isSkip)
			while self.nbFileFound.isVisible():
				QtCore.QCoreApplication.processEvents()
				sleep(0.1)
		if  not self.isMsdataSet:
			self.msdata = MsData(self)
			self.isMsdataSet = True
		if not self.tree.isdbset():
			print("db not setting it")
			self.tree.setdb(self.msdata)
		self.msdata.add_sample_order(to_parse)
		self.orderLoaded = True
		to_parse = self.msdata.getFilesLocation()
		self.loadMsdata(to_parse)

	def isSkip(self):
		print("skipping detected")
		self.skip = True

	def loadMsdata(self, to_parse):
		if  not self.isMsdataSet:
			self.msdata = MsData(self)
			self.isMsdataSet = True
		if not self.tree.isdbset():
			print("db not setting it")
			self.tree.setdb(self.msdata)

		self.loaderinfo  = LoaderInformation(self, len(to_parse), "Chargement de fichier")
		self.loaderinfo.show()
		self.worker = FileQLoader(to_parse)
		print(type(self.worker.info_loading))
		self.worker.info_loading.connect(self.updateInfoLoading)
		self.worker.FileLoaded.connect(self.onFileLoaded)
		self.worker.updateProgressBar.connect(self.loaderinfo.IncrementProgressBar)
		self.worker.errorLoading.connect(self.errorLoadingFile)
		self.thread = QtCore.QThread()
		self.worker.moveToThread(self.thread)
		self.worker.Finished.connect(self.thread.quit)
		self.thread.started.connect(self.worker.parseData)
		self.thread.start()

	def onFileLoaded(self, data):
		self.addSample(data)
		self.loaderinfo.IncrementProgressBar()

	def updateInfoLoading(self, ligne):
		self.loaderinfo.addInfo(ligne)

	def exportbilan(self):
		if self.msdata is None:
			dialog = QtWidgets.QMessageBox(self)
			dialog.setText("Aucune donnée chargee. Veuillez charger des fichiers avant de continuer")
			dialog.open()
		else:
			save_file = QtWidgets.QFileDialog.getSaveFileName(self, "sauvegarde de fichier", "", ".tsv")
			file_saving = open(save_file, 'w')
			sample_name = self.msdata.get_sample_list()
			file_saving.write("samplename\tnb_ms1\tnb_ms2\tbasepeak ms1\tbasepeak ms2\ttic ms1\tic ms2\tcycle duration\n")
			self.loaderinfo = LoaderInformation(self, len(sample_name), u"Export des données")
			self.loaderinfo.show()
			for sample in sample_name:
				data = self.msdata.get_msdata_information(sample)
				file_saving.write(sample+"\t"+str(data['nb_ms1'])+"\t"+str(data['nb_ms2'])+"\t"+str(log10(data['intensity_ms1']))+"\t"+str(log10(data['intensity_ms2']))+"\t"+str(log10(data['tic_ms1']))+"\t"+str(log10(data['tic_ms2']))+"\t"+str(data['max_cycle'])+"\n")
				self.loaderinfo.IncrementProgressBar()
				self.loaderinfo.addInfo(sample+u" exporté avec succès")
			file_saving.close()

	# def export_samplenames(self):
		# if self.msdata is None:
			# dialog = QtGui.QMessageBox(self)
			# dialog.setText("Aucune donnée chargee. Veuillez charger des fichiers avant de continuer")
			# dialog.open()
		# else:
			# save_file = QtGui.QFileDialog.getSaveFileName(self, "sauvegarde de fichier", "", ".tsv")
			# print save_file
			# file_saving = open(save_file, 'w')
			# sample_name = self.msdata.get_sample_list()
			# file_saving.write("Sample\tOrder\tMethod\tWell\n")
			# for sample in sample_name:
				# file_saving.write(sample+"\n")
			# file_saving.close()

	def multiMS1View(self):
		print("multims1")
		cbtree = CheckBoxTree(self)
		sample_list = self.msdata.get_sample_list()
		cbtree.setSamples(sample_list)
		util_qt.clearLayout(self.mainlayout)
		self.mainlayout.addWidget(cbtree, 0,0, 3, 1)
		self.mainlayout.addWidget(self.GraphWidget, 1, 1)


	def viewOrderedResume(self):
		if self.orderLoaded:
			print("summary")
			stree = SummarizeTree(self)
			sample_list = self.msdata.get_sample_list()
			stree.setSamples(sample_list)
			util_qt.clearLayout(self.mainlayout)
			self.mainlayout.addWidget(stree, 0,0, 3, 1)
			self.mainlayout.addWidget(self.GraphWidget, 1, 1)
		else:
			dialog = QtWidgets.QMessageBox(self)
			dialog.setText("Pas d'information d'ordre de passage chargée\n Veuillez charger l'ordre de passage avant de continuer")
			dialog.open()

	def viewBySample(self):
		util_qt.clearLayout(self.GraphWidget)
		util_qt.clearLayout(self.mainlayout)
		self.mainlayout.addWidget(self.tree, 0,0, 3, 1)
		self.mainlayout.addWidget(self.Information, 1, 1)
		self.mainlayout.addWidget(self.GraphWidget, 2, 1)

	def update_statusbar(self, message):
		self.statusBar().showMessage(message)

	def addSample(self, data):
		self.msdata.add_scan(data)
		self.tree.addSampledata(data[0].get_sample_name())


	def saveProject(self):
		save_file = QtWidgets.QFileDialog.getSaveFileName(self, "sauvegarde de fichier", "", ".bz2")[0]
		self.infoloader = LoaderInformation(self, self.msdata.nbEntry()/100, u"Sauvegarde de l'archive "+save_file)
		self.loaderinfo.show()
		#self.loaderinfo.count_loading.connect(self, QtCore.SIGNAL("count_loading"), self.infoloader.IncrementProgressBar)
		self.msdata.dumpDB(save_file)
		nbSample = len(self.msdata.get_sample_list())
		self.infoloader.addInfo(u"sauvegarde de "+str(nbSample)+u" échantillons")

	def loadProject(self):
		self.msdata = MsData(self)
		self.tree.setdb(self.msdata)
		load_file = QtWidgets.QFileDialog.getOpenFileName(self, "Chargement d'une archive", ".bz2")
		self.infoloader = LoaderInformation(self, 0, u"chargement de l'archive "+load_file, progressbar = False)
		self.msdata.loadDB(load_file)
		sample_list = self.msdata.get_sample_list()
		for sample in sample_list:
			self.tree.addSampledata(sample)
		nbSample = len(sample_list)
		self.infoloader.addInfo(u"Chargement de "+str(nbSample)+u" échantillons")
		nbOrder = self.msdata.test_ordered_info()
		print("Nb sample ordered : "+str(nbOrder))
		self.infoloader.addInfo(u""+str(nbSample)+u" échantillons avec ordre de passage")
		self.loaderinfo.show()
		if nbOrder != 0:
			self.orderLoaded = True
		self.infoloader.addCloseButton()

	def errorLoadingFile(self, filename):
		error = QtWidgets.QErrorMessage(self)
		error.showMessage(u'Erreur lors du chargement du fichier '+filename+u'<br />Fichier ignore')

	def clearData(self):
		self.msdata.cleandb()
		self.tree.clearTree()
		self.msdata = None
		self.isMsdataSet = False
		self.samplename.setText("")
		self.Information.cleanTab()
		self.orderLoaded = False
		util_qt.clearLayout(self.graphlayout)

	def loadSampleOrder(self):
		if self.msdata is None:
			dialog = QtWidgets.QMessageBox(self)
			dialog.setText("Aucune donnée chargee. Veuillez charger des fichiers avant de continuer")
			dialog.open()
		else:
			load_file = QtWidgets.QFileDialog.getOpenFileName(self, "Chargement d'une archive", ".tsv")
			self.infoloader = LoaderInformation(self, 0, u"chargement de l'ordre de passage "+load_file, progressbar = False)
			self.loaderinfo.show()
			input_file = open(load_file, "r")
			datas = []
			first_line = True
			for line in input_file:
				tabline = line.strip('\n').split("\t")
				if first_line:
					fisrt_line = False
					if tabline[0] == "Sample" and tabline[1] == "Order" and tabline[2] == "Method" and tabline[3] == "Well":
						first_line = False
					else:
						dialog = QtWidgets.QMessageBox(self)
						dialog.setText("Ce fichier n'est pas compatible. Veuillez utiliser un fichier au bon format")
						dialog.open()
						break
				else:
					datas.append(tabline)
			self.msdata.add_sample_order(datas)
			self.infoloader.addCloseButton()
			self.orderLoaded = True

	def resizeEvent(self, e):
		QtWidgets.QWidget.resizeEvent(self, e)

		print("resizing detected")
		size = self.geometry()
		self.MainWidget.setGeometry(0,15, size.width()-20, size.height()-20)
		print(str(size.width())+"x"+str(size.height()))

def main():

    app = QtWidgets.QApplication(sys.argv)
    ex = MainWindow()
    sys.exit(app.exec_())


if __name__ == '__main__':
    main()
