import matplotlib
matplotlib.use('Qt5agg')
from matplotlib.backends import qt_compat
from PyQt5 import QtGui, QtCore, QtWidgets

import numpy as np
from matplotlib.backends.backend_qt4agg import FigureCanvasQTAgg as FigureCanvas
from matplotlib.figure import Figure
import matplotlib.pyplot as plt
import matplotlib.cm as cm

class Graph(FigureCanvas):
	"""Ultimately, this is a QWidget (as well as a FigureCanvasAgg, etc.)."""
	def __init__(self, parent=None, width=5, height=4, dpi=100):
		self.parent = parent
		self.fig, self.axes = plt.subplots()
		#self.fig.width = width
		#self.fig.height = height
		#self.fig.dpi = dpi

		FigureCanvas.__init__(self, self.fig)
		self.setParent(self.parent)
		self.setMinimumSize(300, 200)
		#FigureCanvas.setSizePolicy(self, QtGui.QSizePolicy.Expanding,QtGui.QSizePolicy.Expanding)
		FigureCanvas.updateGeometry(self)


## recuperation d'un objet plot a afficher
	def get_plot(self, data, xlab, ylab, title):
		plt.close()
		self.fig.suptitle(title, fontsize=14, fontweight='bold')
		self.axes.set_xlabel(xlab)
		self.axes.set_ylabel(ylab)
		self.axes.plot(data.keys(), data.values(), 'r')
		FigureCanvas.__init__(self, self.fig)
		self.setParent(self.parent)

		FigureCanvas.setSizePolicy(self, QtWidgets.QSizePolicy.Expanding,QtWidgets.QSizePolicy.Expanding)
		FigureCanvas.updateGeometry(self)

	def get_plot_from_array(self, datax, datay, xlab, ylab, title):
		plt.close()
		self.fig.suptitle(title, fontsize=14, fontweight='bold')
		self.axes.set_xlabel(xlab)
		self.axes.set_ylabel(ylab)
		self.axes.plot(datax, datay, 'r')
		FigureCanvas.__init__(self, self.fig)
		self.setParent(self.parent)

		FigureCanvas.setSizePolicy(self, QtWidgets.QSizePolicy.Expanding,QtWidgets.QSizePolicy.Expanding)
		FigureCanvas.updateGeometry(self)
## recuperation d'un barplot a afficher

	def get_barplot_from_dict(self, data, ylab, width, title):
		plt.close()
		self.fig.suptitle(title, fontsize=14, fontweight='bold')
		ind = np.arange(len(data.values()))
		self.axes.bar(ind, data.values(), width, color='r')
		self.axes.set_ylabel(ylab)
		self.axes.set_xticks(ind+width)
		self.axes.set_xticklabels( data.keys() )
		FigureCanvas.__init__(self, self.fig)
		self.setParent(self.parent)

		FigureCanvas.setSizePolicy(self, QtWidgets.QSizePolicy.Expanding,QtWidgets.QSizePolicy.Expanding)
		FigureCanvas.updateGeometry(self)

	def get_hist_from_tab(self, data, ylab, num_bins, title):
		plt.close()
		self.fig.suptitle(title, fontsize=14, fontweight='bold')
		n, bins, patches = self.axes.hist(data, num_bins, facecolor='red', alpha=0.5)
		self.axes.set_ylabel(ylab)
		#self.axes.set_xticks(ind+width)
		#self.axes.set_xticklabels( data.keys() )
		FigureCanvas.__init__(self, self.fig)
		self.setParent(self.parent)

		FigureCanvas.setSizePolicy(self, QtWidgets.QSizePolicy.Expanding,QtWidgets.QSizePolicy.Expanding)
		FigureCanvas.updateGeometry(self)

	def get_multiplot_from_dict(self, data, xlab, ylab, title, color = False):
		plt.close()
		self.fig.suptitle(title, fontsize=14, fontweight='bold')
		if not color:
			colors = cm.rainbow(np.linspace(0,1, len(data.keys())))
			for sample, c in zip(data.keys(), colors):
				data[sample].append(c)
			self.axes.set_xlabel(xlab)
			self.axes.set_ylabel(ylab)
			for sample, c in zip(data.keys(), colors):
				print(sample+" : "+str(c))
				self.axes.plot(data[sample][0], data[sample][1], color = data[sample][2])
		else:
			for sample in data.keys():
				self.axes.plot(data[sample][0], data[sample][1], color = data[sample][2])
		FigureCanvas.__init__(self, self.fig)
		self.setParent(self.parent)

		FigureCanvas.setSizePolicy(self, QtWidgets.QSizePolicy.Expanding,QtWidgets.QSizePolicy.Expanding)
		FigureCanvas.updateGeometry(self)

	def get_multiscatterlot_from_dict(self, data, xlab, ylab, title):
		plt.close()
		self.fig.suptitle(title, fontsize=14, fontweight='bold')
		colors = cm.rainbow(np.linspace(0,1, len(data.keys())))
		self.axes.set_xlabel(xlab)
		self.axes.set_ylabel(ylab)
		for sample, c in zip(data.keys(), colors):
			print(sample+" : "+str(c))
			print(sample+" order : "+str(data[sample][0])+", value : "+str(data[sample][1]))
			self.axes.scatter(data[sample][0], data[sample][1], color = c)
		FigureCanvas.__init__(self, self.fig)
		self.setParent(self.parent)

		FigureCanvas.setSizePolicy(self, QtWidgets.QSizePolicy.Expanding,QtWidgets.QSizePolicy.Expanding)
		FigureCanvas.updateGeometry(self)

	def updateSize(self):
		FigureCanvas.updateGeometry(self)
