import pymzml
from mzxml_scan import mzxml_scan

class mzMLHandler:

    def __init__(self, fullpathname):
        self.run  = pymzml.run.Reader(fullpathname)
        print(self.run.get_spectrum_count())

    def set_export(self, export, sample_name):
        self.export = export
        self.sample_name = sample_name

    def parse(self):
        previous_ms1_scan_num = 0
        for spectrum in self.run:
            current_scan = mzxml_scan(spectrum.ID)
            current_scan.set_scan_info(spectrum.ms_level, spectrum.scan_time[0],spectrum.get('MS:1000505'), spectrum.TIC, spectrum.get('MS:1000504'))
            # print(f"TIC pour le Spectre {spectrum.ID} : {spectrum.TIC}")
            # print(f"msLevel pour le Spectre {spectrum.ID} : {spectrum.ms_level}")
            # print(f"RT pour le Spectre {spectrum.ID} : {spectrum.scan_time}")
            # print(f"base peak intensity pour le Spectre {spectrum.ID} :  {spectrum.get('MS:1000504')} {spectrum.get('MS:1000505')}")
            if spectrum.ms_level == 1:
                previous_ms1_scan_num = spectrum.ID
            if spectrum.ms_level == 2:
                current_scan.set_precursor_scan_info(previous_ms1_scan_num, spectrum.get('MS:1000744'), spectrum.get('MS:1000042'),spectrum.get('MS:1000041'))
                # print(f"precursor MZ : {spectrum.get('MS:1000744')}")
                # print(f"precursor Charge : {spectrum.get('MS:1000041')}")
                # print(f"precursor intensity : {spectrum.get('MS:1000042')}")
                # print(f"precursor scan num : {previous_ms1_scan_num}")
            current_scan.set_sample_name(self.sample_name)
            self.export.append(current_scan)
            current_scan = None
