﻿# -*- coding: utf-8 -*-

from PyQt5 import QtGui, QtCore, QtWidgets
import os
import sys
import traceback
import time
import xml.sax
from Parser.mzXMLHandler import mzXMLHandler
from Parser.mzMLHandler import mzMLHandler
from msdata import MsData


class FileQLoader(QtCore.QObject):
	info_loading = QtCore.pyqtSignal(str)
	FileLoaded = QtCore.pyqtSignal(list)
	errorLoading = QtCore.pyqtSignal(str)
	updateProgressBar = QtCore.pyqtSignal()
	Finished = QtCore.pyqtSignal()

	def __init__(self, filenames):
		QtCore.QObject.__init__(self)
		self.filenames = filenames


	def parseData(self):
		filetype = None
		handler = mzXMLHandler()
		for datafile in self.filenames:
			print(datafile)
			if datafile[datafile.rindex(".")+1:] == "mzXML":
				filetype = "mzXML"
			elif datafile[datafile.rindex(".")+1:] == "mzML":
				filetype = "mzML"
			print(f"filetype is {filetype}")
			data = []
			ligne =  'traitement du fichier '+datafile
			print(ligne)
			self.info_loading.emit(ligne)
			start = time.time()
			print(datafile)
			filename = datafile[datafile.rindex("/")+1:datafile.rindex('.')]
			try:
				if filetype == "mzXML":
					handler.set_export(data, filename)
					parser = xml.sax.make_parser()
					parser.setContentHandler(handler)
					parser.parse(open(datafile,"r"))
				elif filetype == "mzML":
					print("start parsing mzML file")
					parser  = mzMLHandler(datafile)
					parser.set_export(data, filename)
					parser.parse()
				end = time.time()
				ligne =  'fichier '+datafile+" traite en "+str(end - start)+'s'
				print(ligne)
				self.info_loading.emit(ligne)
				self.FileLoaded.emit(data)
			except:
				exc_type, exc_value, exc_traceback = sys.exc_info()
				traceback.print_exception(exc_type, exc_value, exc_traceback)
				self.errorLoading.emit(filename)
				self.updateProgressBar.emit()
		self.Finished.emit()
