from PyQt4 import QtGui
from PyQt4 import QtCore
import math

### import perso
from graph import Graph
import util_qt
from operator import itemgetter

class SummarizeTree(QtGui.QTreeWidget):
	
	def __init__(self, parent):
		super(SummarizeTree, self).__init__(parent.MainWidget)
		self.parent = parent
		self.setHeaderLabels(["Information"])
		self.setFixedWidth(300)
		self.setMinimumHeight(690)
		self.setColumnCount(1)
		self.connect(self, QtCore.SIGNAL('itemClicked(QTreeWidgetItem*, int)'), self.onClick)
		
	def setSamples(self, sample_list):
		self.mylist = []
		for samplename in sample_list:
			self.mylist.append(self.parent.msdata.get_msdata_information(samplename))
		self.mylist = sorted(self.mylist, key=itemgetter('order'))
		## mscount
		ms_number = QtGui.QTreeWidgetItem(self)
		ms_number.setText(0, "MS event count")
		self.addTopLevelItem(ms_number)
		#### tic intensity
		int_tic_plot = QtGui.QTreeWidgetItem(self)
		int_tic_plot.setText(0, "MS mean intensity")
		self.addTopLevelItem(int_tic_plot)
		
		
	def onClick(self, item, column):
		sample_list = {}
		root = self.invisibleRootItem()
		child_count = root.childCount()
		if item.text(column) is not "":
			if item.text(0) == "MS event count":
				data = {}
				data['ms1'] = []
				data['ms2'] = []
				order = []
				ms1 = []
				ms2 = []
				for sample in self.mylist:
					order.append(sample['order'])
					ms1.append(sample['nb_ms1'])
					ms2.append(sample['nb_ms2'])
				data['ms1'] = [order, ms1]
				data['ms2'] = [order, ms2]
				util_qt.clearLayout(self.parent.graphlayout)
				self.graph = Graph(self.parent.GraphWidget)
				self.graph.get_multiscatterlot_from_dict(data, "sample order", "Nb MS Event", "Number of MS event sort by sample order")
				self.parent.graphlayout.addWidget(self.graph)
				self.graph.setContextMenuPolicy(QtCore.Qt.CustomContextMenu)
				self.graph.customContextMenuRequested.connect(self.showMenu)
			if item.text(0) == "MS mean intensity":
				data = {}
				data['ms1'] = []
				data['ms2'] = []
				order = []
				ms1 = []
				ms2 = []
				for sample in self.mylist:
					order.append(sample['order'])
					ms1.append(math.log10(sample['tic_ms1']))
					ms2.append(math.log10(sample['tic_ms2']))
				data['ms1'] = [order, ms1]
				data['ms2'] = [order, ms2]
				util_qt.clearLayout(self.parent.graphlayout)
				self.graph = Graph(self.parent.GraphWidget)
				self.graph.get_multiscatterlot_from_dict(data, "sample order", "Mean TIC intensity", "Mean TIC intensity sort by sample order")
				self.parent.graphlayout.addWidget(self.graph)
				self.graph.setContextMenuPolicy(QtCore.Qt.CustomContextMenu)
				self.graph.customContextMenuRequested.connect(self.showMenu)
				
	def showMenu(self, pos):
		menu = QtGui.QMenu(self)
		saveas = QtGui.QAction("&Save as", menu)
		saveas.triggered.connect(self.saveCurrentGraph)
		menu.addAction(saveas)
		menu.popup(QtGui.QCursor.pos())
	
	def saveCurrentGraph(self):
		selectedFilter = QtCore.QString()
		save_file = QtGui.QFileDialog.getSaveFileName(self, "nom du Fichier", "", "png;;pdf", selectedFilter)
		save_file = unicode(save_file+"."+selectedFilter)
		self.graph.fig.savefig(save_file)			
	
		