from PyQt4 import QtGui
from PyQt4 import QtCore
from numpy import histogram

### import perso
from graph import Graph
import util_qt

class SampleTree(QtGui.QTreeWidget):
	
	def __init__(self, parent):
		super(SampleTree, self).__init__(parent.MainWidget)
		self.parent = parent
		self.setHeaderLabels(["Samples"])
		#self.setMinimumSize(300, 800)
		self.setFixedWidth(300)
		self.setMinimumHeight(790)
		self.setColumnCount(1)
		self.Sample_list = []
		self.connect(self, QtCore.SIGNAL('itemClicked(QTreeWidgetItem*, int)'), self.onClick)
		self.dbset = False
		self.currentSample = None
		self.currentView = None


	def addSampledata(self, sample_name):
		Sample = QtGui.QTreeWidgetItem(self)
		Sample.setText(0, sample_name)
		self.addTopLevelItem(Sample)
		MsData = QtGui.QTreeWidgetItem(Sample, ["MsData"])
		Sample.addChild(MsData)
		signal_ms1 = QtGui.QTreeWidgetItem(MsData, ["MS1 basebeak signal"])
		Signal_ms2 = QtGui.QTreeWidgetItem(MsData, ["MS2 basepeak signal"])
		scan_charge = QtGui.QTreeWidgetItem(MsData, ["Scan per charge"])
		count_scan = QtGui.QTreeWidgetItem(MsData, ["ms2 per ms during run"])
		hist_count = QtGui.QTreeWidgetItem(MsData, ["ms2 per ms count distribution"])
		precursor = QtGui.QTreeWidgetItem(MsData, ["Precursor mass distribution"])
		cycle_time = QtGui.QTreeWidgetItem(MsData, ["Cycle duration distribution"])
		precursor_int = QtGui.QTreeWidgetItem(MsData, ["precursor intensity"])
		MsData.addChild(signal_ms1)
		MsData.addChild(Signal_ms2)
		MsData.addChild(scan_charge)
		MsData.addChild(count_scan)
		MsData.addChild(hist_count)
		MsData.addChild(precursor)
		MsData.addChild(cycle_time)
		MsData.addChild(precursor_int)
		#MsData = QtGui.QTreeWidgetItem(Sample, ["","MsData"])
		self.setItemExpanded(Sample, False)
		self.Sample_list.append(Sample)
		#Sample.setSizeHint(0, QtCore.QSize(50, 10))
		#Sample.setSizeHint(1, QtCore.QSize(50, 10))
		
	def isdbset(self):
		return self.dbset
		
	def setdb(self, db):
		self.db = db
		self.dbset = True
		
	def onClick(self, item, column):
		print str(column)+" : "+item.text(column)+" clicker"
		try:
			print "parent : "+item.parent().text(0)
		except:
			print "pas de parent"
		#print "grand parent : "+item.parent().parent().text(0)
		if item.text(column) is not "":
			if item.text(0) == "MsData":
				sample_name = item.parent().text(0)
				self.parent.samplename.setText(sample_name)
				data = self.db.get_msdata_information(sample_name)
				self.parent.Information.add_msdata_info(data)
				if column == 0:
					util_qt.clearLayout(self.parent.graphlayout)
					print "selection du type de donnees a afficher"
					print "affichage tic ms par defaut"
					data = self.db.get_intensity_for_sample_by_level(sample_name, 1)
					self.graph = Graph(self.parent.GraphWidget)
					self.graph.get_plot_from_array(data[0], data[1], "Retention time", "intensity", "Ms1 basepeak intensity")
					self.parent.graphlayout.addWidget(self.graph)
					self.graph.setContextMenuPolicy(QtCore.Qt.CustomContextMenu)
					self.graph.customContextMenuRequested.connect(self.showMenu)					
			elif item.text(column) == "MS1 basebeak signal":
				sample_name = item.parent().parent().text(0)
				self.parent.samplename.setText(sample_name)
				data = self.db.get_msdata_information(sample_name)
				self.parent.Information.add_msdata_info(data)
				util_qt.clearLayout(self.parent.graphlayout)
				data = self.db.get_intensity_for_sample_by_level(sample_name, 1)
				self.graph = Graph(self.parent.GraphWidget)
				self.graph.get_plot_from_array(data[0], data[1], "Retention time", "intensity", "Ms1 basepeak intensity")
				self.parent.graphlayout.addWidget(self.graph)
				self.graph.setContextMenuPolicy(QtCore.Qt.CustomContextMenu)
				self.graph.customContextMenuRequested.connect(self.showMenu)
			elif item.text(column) == "MS2 basepeak signal":
				sample_name = item.parent().parent().text(0)
				self.parent.samplename.setText(sample_name)
				data = self.db.get_msdata_information(sample_name)
				self.parent.Information.add_msdata_info(data)
				util_qt.clearLayout(self.parent.graphlayout)
				data = self.db.get_intensity_for_sample_by_level(sample_name, 2)
				self.graph = Graph(self.parent.GraphWidget)
				self.graph.get_plot_from_array(data[0], data[1], "Retention time", "intensity", "Ms2 basepeak intensity")
				self.parent.graphlayout.addWidget(self.graph)
				self.graph.setContextMenuPolicy(QtCore.Qt.CustomContextMenu)
				self.graph.customContextMenuRequested.connect(self.showMenu)
			elif item.text(column) == "Scan per charge":
				sample_name = item.parent().parent().text(0)
				self.parent.samplename.setText(sample_name)
				data = self.db.get_msdata_information(sample_name)
				self.parent.Information.add_msdata_info(data)
				util_qt.clearLayout(self.parent.graphlayout)
				data = self.db.get_nb_precursor_charges_by_charge_for_level_for_sample(2, sample_name)
				self.graph = Graph(self.parent.GraphWidget)
				self.graph.get_barplot_from_dict(data, "scan count", 1, "Charge state distribution")
				self.parent.graphlayout.addWidget(self.graph)
				self.graph.setContextMenuPolicy(QtCore.Qt.CustomContextMenu)
				self.graph.customContextMenuRequested.connect(self.showMenu)
			elif item.text(column) == "ms2 per ms during run":
				sample_name = item.parent().parent().text(0)
				self.parent.samplename.setText(sample_name)
				data = self.db.get_msdata_information(sample_name)
				self.parent.Information.add_msdata_info(data)
				util_qt.clearLayout(self.parent.graphlayout)
				data = self.db.get_nb_ms2_by_ms_for_sample_ordered(sample_name)
				self.graph = Graph(self.parent.GraphWidget)
				self.graph.get_plot_from_array(data[0], data[1], "Retention time", "ms2 par ms count", "ms2 per ms during run")
				self.parent.graphlayout.addWidget(self.graph)
				self.graph.setContextMenuPolicy(QtCore.Qt.CustomContextMenu)
				self.graph.customContextMenuRequested.connect(self.showMenu)
			elif item.text(column) == "ms2 per ms count distribution":
				sample_name = item.parent().parent().text(0)
				self.parent.samplename.setText(sample_name)
				data = self.db.get_msdata_information(sample_name)
				self.parent.Information.add_msdata_info(data)
				util_qt.clearLayout(self.parent.graphlayout)
				data = self.db.get_nb_ms2_by_ms_for_sample_ordered(sample_name)
				bin = max(data[1])
				self.graph = Graph(self.parent.GraphWidget)
				self.graph.get_hist_from_tab(data[1], "count", bin, "ms2 per ms count distribution")
				self.parent.graphlayout.addWidget(self.graph)
				self.graph.setContextMenuPolicy(QtCore.Qt.CustomContextMenu)
				self.graph.customContextMenuRequested.connect(self.showMenu)
			elif item.text(column) == "Precursor mass distribution":
				sample_name = item.parent().parent().text(0)
				self.parent.samplename.setText(sample_name)
				data = self.db.get_msdata_information(sample_name)
				self.parent.Information.add_msdata_info(data)
				util_qt.clearLayout(self.parent.graphlayout)
				data = self.db.get_precursor_ms_for_sample(sample_name)
				#print data
				#hist = histogram(data, 100)
				#print hist
				self.graph = Graph(self.parent.GraphWidget)
				self.graph.get_hist_from_tab(data, "nb precursor", 100, "Precursor mass distribution")
				self.parent.graphlayout.addWidget(self.graph)
				self.graph.setContextMenuPolicy(QtCore.Qt.CustomContextMenu)
				self.graph.customContextMenuRequested.connect(self.showMenu)
			elif item.text(column) == "Cycle duration distribution":
				sample_name = item.parent().parent().text(0)
				self.parent.samplename.setText(sample_name)
				data = self.db.get_msdata_information(sample_name)
				self.parent.Information.add_msdata_info(data)
				util_qt.clearLayout(self.parent.graphlayout)
				data = self.db.get_cycle_duration_for_sample(sample_name)
				self.graph = Graph(self.parent.GraphWidget)
				self.graph.get_hist_from_tab(data.values(), "Cycle duration", 100, "Cycle duration distribution")
				self.parent.graphlayout.addWidget(self.graph)
				self.graph.setContextMenuPolicy(QtCore.Qt.CustomContextMenu)
				self.graph.customContextMenuRequested.connect(self.showMenu)
			elif item.text(column) == "precursor intensity":
				sample_name = item.parent().parent().text(0)
				self.parent.samplename.setText(sample_name)
				data = self.db.get_msdata_information(sample_name)
				self.parent.Information.add_msdata_info(data)
				util_qt.clearLayout(self.parent.graphlayout)
				data = self.db.get_precursor_intensity_for_sample(sample_name)
				self.graph = Graph(self.parent.GraphWidget)
				self.graph.get_hist_from_tab(data, "Precursors count", 100, " Log10 Precursor intensity distribution")
				self.parent.graphlayout.addWidget(self.graph)
				self.graph.setContextMenuPolicy(QtCore.Qt.CustomContextMenu)
				self.graph.customContextMenuRequested.connect(self.showMenu)
				
			else:
				util_qt.clearLayout(self.parent.graphlayout)
				data = self.db.get_msdata_information(item.text(column))
				self.parent.Information.add_msdata_info(data)
				self.parent.samplename.setText(item.text(column))
				
	def showMenu(self, pos):
		menu = QtGui.QMenu(self)
		saveas = QtGui.QAction("&Save as", menu)
		saveas.triggered.connect(self.saveCurrentGraph)
		menu.addAction(saveas)
		menu.popup(QtGui.QCursor.pos())
	
	def saveCurrentGraph(self):
		selectedFilter = QtCore.QString()
		save_file = QtGui.QFileDialog.getSaveFileName(self, "nom du Fichier", "", "png;;pdf", selectedFilter)
		save_file = unicode(save_file+"."+selectedFilter)
		self.graph.fig.savefig(save_file)
		
	def clearTree(self):
		self.clear()
		self.Sample_list = []
		self.db = None
		self.dbset = False
		
	def resizeGraph(self):
		self.graph.updateSize()