﻿# -*- coding: utf-8 -*-

from PyQt4 import QtCore
from PyQt4 import QtGui
import os
import sys
import traceback
import time
import xml.sax
from mzXMLHandler import mzXMLHandler
from msdata import MsData


class FileQLoader(QtCore.QObject):

	
	def __init__(self, filenames):
		QtCore.QObject.__init__(self)
		self.filenames = filenames
		

	def parseData(self):
		handler = mzXMLHandler()
		for datafile in self.filenames:
			print datafile
			data = []
			ligne =  'traitement du fichier '+datafile
			print ligne
			self.emit(QtCore.SIGNAL('info_loading'), ligne)
			start = time.clock()
			filename = datafile[datafile.rindex(os.sep)+1:datafile.rindex('.')]
			try:
				handler.set_export(data, filename)
				parser = xml.sax.make_parser()
				parser.setContentHandler(handler)
				parser.parse(open(datafile,"r"))
				end = time.clock()
				ligne =  'fichier '+datafile+" traite en "+str(end - start)+'s'
				print ligne
				self.emit(QtCore.SIGNAL('info_loading'), ligne)
				self.emit(QtCore.SIGNAL("FileLoaded"), data)
			except:
				exc_type, exc_value, exc_traceback = sys.exc_info()
				traceback.print_exception(exc_type, exc_value, exc_traceback)
				self.emit(QtCore.SIGNAL('errorLoading'), filename)
				self.emit(QtCore.SIGNAL('updateProgressBar'))
		self.emit(QtCore.SIGNAL("Finished"))
			


