from PyQt4 import QtGui
from PyQt4 import QtCore
import math

class InformationTab(QtGui.QTableWidget):
	
	def __init__(self,parent):
		super(InformationTab, self).__init__(parent)
		self.setFixedHeight(85)
		self.setMinimumWidth(650)
		self.setColumnCount(7)
		self.setRowCount(2)
		self.horizontalHeader().hide()
		self.verticalHeader().hide()
		self.setItem(0, 1, QtGui.QTableWidgetItem("Nb MS1"))
		self.setItem(0, 2, QtGui.QTableWidgetItem("Nb MS2"))
		self.setItem(0, 3, QtGui.QTableWidgetItem("intensite MS1(basepeak)"))
		self.setItem(0, 4, QtGui.QTableWidgetItem("intensite MS2(basepeak)"))
		self.setItem(0, 5, QtGui.QTableWidgetItem("intensite MS1(tic)"))
		self.setItem(0, 6, QtGui.QTableWidgetItem("intensite MS2(tic)"))
		# self.setItem(2, 1, QtGui.QTableWidgetItem("Nb MS2 utilise"))
		# self.setItem(2, 2, QtGui.QTableWidgetItem("Nb MS2 assigne"))
		# self.setItem(2, 3, QtGui.QTableWidgetItem("Nb peptide unique"))
		self.verticalHeader().setDefaultSectionSize(20)

	def add_msdata_info(self, data_info):
		self.setItem(1, 0, QtGui.QTableWidgetItem("msdata"))
		self.setItem(1, 1, QtGui.QTableWidgetItem(str(data_info['nb_ms1'])))
		self.setItem(1, 2, QtGui.QTableWidgetItem(str(data_info['nb_ms2'])))
		self.setItem(1, 3, QtGui.QTableWidgetItem(str(math.log10(data_info['intensity_ms1']))))
		self.setItem(1, 4, QtGui.QTableWidgetItem(str(math.log10(data_info['intensity_ms2']))))
		self.setItem(1, 5, QtGui.QTableWidgetItem(str(math.log10(data_info['tic_ms1']))))
		self.setItem(1, 6, QtGui.QTableWidgetItem(str(math.log10(data_info['tic_ms2']))))
		self.show()
		
	def cleanTab(self):
		self.hide()

