from PyQt4 import QtGui
from PyQt4 import QtCore
import matplotlib.cm as cm
import numpy as np

### import perso
from graph import Graph
import util_qt

class CheckBoxTree(QtGui.QTreeWidget):
	
	def __init__(self, parent):
		super(CheckBoxTree, self).__init__(parent.MainWidget)
		self.parent = parent
		self.setHeaderLabels(["Samples"])
		self.setFixedWidth(300)
		self.setMinimumHeight(790)
		self.setColumnCount(1)

		
	def setSamples(self, sample_list):
		self.mydict = {}
		colors = cm.rainbow(np.linspace(0,1, len(sample_list)))
		i=0
		for sample_name in sample_list:
			Sample = QtGui.QTreeWidgetItem(self)
			Sample.setCheckState(0, QtCore.Qt.Unchecked)
			Sample.setFlags(QtCore.Qt.ItemIsUserCheckable | QtCore.Qt.ItemIsEnabled)
			Sample.setText(0, sample_name)
			self.addTopLevelItem(Sample)
			self.mydict[sample_name] = self.parent.msdata.get_intensity_for_sample_by_level(sample_name, 1)
			self.mydict[sample_name].append(colors[i])
			i = i+1
			print "sample "+sample_name+" loaded"
		self.itemChanged.connect(self.handleItemChanged)
		
		
	def handleItemChanged(self, item, column):
		sample_list = {}
		root = self.invisibleRootItem()
		child_count = root.childCount()
		for i in range(child_count):
			if root.child(i).checkState(0) == QtCore.Qt.Checked:
				sample_list[str(root.child(i).text(0))] = self.mydict[str(root.child(i).text(0))]
		util_qt.clearLayout(self.parent.graphlayout)
		self.graph = Graph(self.parent.GraphWidget)
		self.graph.get_multiplot_from_dict(sample_list, "scan_num", "intensity", "MS1 basepeak intensity multiples samples", color=True)
		self.parent.graphlayout.addWidget(self.graph)
		self.graph.setContextMenuPolicy(QtCore.Qt.CustomContextMenu)
		self.graph.customContextMenuRequested.connect(self.showMenu)
			
		
	def showMenu(self, pos):
		menu = QtGui.QMenu(self)
		saveas = QtGui.QAction("&Save as", menu)
		saveas.triggered.connect(self.saveCurrentGraph)
		menu.addAction(saveas)
		menu.popup(QtGui.QCursor.pos())
	
	def saveCurrentGraph(self):
		selectedFilter = QtCore.QString()
		save_file = QtGui.QFileDialog.getSaveFileName(self, "nom du Fichier", "", "png;;pdf", selectedFilter)
		save_file = unicode(save_file+"."+selectedFilter)
		self.graph.fig.savefig(save_file)
