# -*- coding: utf-8 -*-

from PyQt4 import QtGui
from PyQt4 import QtCore


class LoaderInformation(QtGui.QWidget):

	def __init__(self, parent, length, title, progressbar = True):
		super(LoaderInformation, self).__init__()
		self.setWindowTitle(title)
		self.mainLayout = QtGui.QGridLayout()
		if progressbar:
			self.progressbar = QtGui.QProgressBar(self)
			self.progressbar.setMinimum(1)
			self.progressbar.setMaximum(length)
			self.mainLayout.addWidget(self.progressbar, 0 , 0)
		self.textbox = QtGui.QTextEdit(self)
		self.text = ""
		self.mainLayout.addWidget(self.textbox, 1, 0)
		self.setLayout(self.mainLayout)

		
	def IncrementProgressBar(self):
		value = self.progressbar.value() +1
		self.progressbar.setValue(value)
		if self.progressbar.value() == self.progressbar.maximum():
			self.addCloseButton()
	
	def addInfo(self, ligne):
		self.text = self.text +ligne+"\n"
		self.textbox.setText(self.text)
		
	def addCloseButton(self):
		button = QtGui.QPushButton('Close', self)
		button.clicked.connect(self.close)
		self.mainLayout.addWidget(button, 2, 0)
		
	def addYesButton(self, text):
		self.yes = QtGui.QPushButton(text, self)
		self.yes.clicked.connect(self.close)
		self.mainLayout.addWidget(self.yes, 2, 0)
		
	def addNoButton(self, text):
		self.No = QtGui.QPushButton(text, self)
		self.No.clicked.connect(self.noClicked)
		self.mainLayout.addWidget(self.No, 2, 1)
		
	def noClicked(self):
		self.emit(QtCore.SIGNAL('skip file'))
		self.close()
		
	def setLengthOfProgressBar(length):
		self.progressbar.setMinimum(1)
		self.progressbar.setMaximum(length)