//
// File: test_cborpsm.cpp
// Created by: Olivier Langella
// Created on: 8/7/2025
//
/*******************************************************************************
 * Copyright (c) 2025 Olivier Langella <Olivier.Langella@universite-paris-saclay.fr>.
 *
 * This file is part of the PAPPSOms++ library.
 *
 *     PAPPSOms++ is free software: you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation, either version 3 of the License, or
 *     (at your option) any later version.
 *
 *     PAPPSOms++ is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with PAPPSOms++.  If not, see <http://www.gnu.org/licenses/>.
 *
 ******************************************************************************/

// ./tests/pappsotree/catch2-only-pappsotree [cborpsm] -s
// ./tests/pappsotree/catch2-only-pappsotree [cborfeatures] -s

#include <catch2/catch_test_macros.hpp>
#include <pappsomspp/processing/cbor/psm/evalscan/psmfeatures.h>
#include <pappsomspp/processing/cbor/psm/psmcbor2json.h>
#include <pappsomspp/processing/cbor/psm/psmfileappend.h>
#include <pappsomspp/processing/cbor/psm/psmfilereaderbase.h>
#include <pappsomspp/processing/uimonitor/uimonitorvoid.h>
#include <odsstream/odsdocwriter.h>
#include <QDebug>

class CborTest : public pappso::cbor::psm::PsmFileReaderBase
{
  public:
  CborTest(CalcWriterInterface &output) : m_output(output)
  {
    m_output.writeSheet("psm list");
    m_output.writeCell("index");
    m_output.writeCell("sample");
    m_output.writeCell("Proforma");
    m_output.writeLine();
  };

  void
  psmReady(pappso::UiMonitorInterface &monitor [[maybe_unused]]) override
  {

    // qDebug() << "coucou";
    m_output.writeCell((std::size_t)m_cborScanId.value("index").toInteger());
    m_output.writeCell(m_currentSampleName);
    m_output.writeCell(m_currentPsmProforma);
    m_output.writeLine();
  };

  private:
  CalcWriterInterface &m_output;
};

TEST_CASE("cbor psm map test suite.", "[cborfeatures]")
{
  // Set the debugging message formatting pattern.
  qSetMessagePattern(QString("%{file}@%{line}, %{function}(): %{message}"));


  SECTION("..:: PSM cbor features::..", "[cborfeatures]")
  {
    pappso::UiMonitorVoid monitor;

    QFile cbor_file(
      "/gorgone/pappso/moulon/users/Olivier/20250402_RD_mais_deepprot/specoms/"
      "specoms_1_F2_vs_B73.cbor");
    cbor_file.open(QIODevice::ReadOnly);

    QFile features_file("features.cbor");
    features_file.open(QIODevice::WriteOnly);
    pappso::cbor::CborStreamWriter writer(&features_file);

    pappso::cbor::psm::PsmFeatures psm_features(1000, &writer);

    psm_features.readCbor(&cbor_file, monitor);
    // xic_writer.write(xic);
    features_file.close();
    cbor_file.close();
  }
}

TEST_CASE("cbor psm map test suite.", "[cborpsm]")
{
  // Set the debugging message formatting pattern.
  qSetMessagePattern(QString("%{file}@%{line}, %{function}(): %{message}"));


  SECTION("..:: PSM cbor map ::..", "[cborpsm]")
  {
    pappso::UiMonitorVoid monitor;

    QFile cbor_file(
      "/gorgone/pappso/moulon/users/Olivier/20250402_RD_mais_deepprot/specoms/"
      "specoms_1_F2_vs_B73.cbor");
    cbor_file.open(QIODevice::ReadOnly);


    QFile fileods("test.ods");
    OdsDocWriter writer(&fileods);


    CborTest cbor_pappso(writer);
    cbor_pappso.readCbor(&cbor_file, monitor);
    // xic_writer.write(xic);
    writer.close();
    fileods.close();
  }
  SECTION("..:: PSM cbor append file ::..", "[cborpsm]")
  {
    pappso::UiMonitorVoid monitor;

    QFile output_file_cbor("append.cbor");
    output_file_cbor.open(QIODevice::WriteOnly);
    pappso::cbor::CborStreamWriter cbor_output(&output_file_cbor);

    pappso::cbor::psm::PsmFileAppend append_cbor(&cbor_output);


    QFile cbor_file(
      "/gorgone/pappso/moulon/users/Olivier/20250402_RD_mais_deepprot/specoms/"
      "specoms_1_F2_vs_B73.cbor");
    cbor_file.open(QIODevice::ReadOnly);
    append_cbor.readCbor(&cbor_file, monitor);
    cbor_file.close();
    REQUIRE(true);

    QFile cbor_file2(
      "/gorgone/pappso/moulon/users/Olivier/20250402_RD_mais_deepprot/specoms/"
      "specoms_2_F2_vs_B73.cbor");
    cbor_file2.open(QIODevice::ReadOnly);
    append_cbor.readCbor(&cbor_file2, monitor);
    cbor_file2.close();

    REQUIRE(true);


    append_cbor.close();
    output_file_cbor.close();


    QFile fileods("append.ods");
    OdsDocWriter writer(&fileods);


    REQUIRE(true);
    CborTest cbor_pappso(writer);
    QFile cbor_file3("append.cbor");
    cbor_file3.open(QIODevice::ReadOnly);
    cbor_pappso.readCbor(&cbor_file3, monitor);
    // xic_writer.write(xic);
    writer.close();
    fileods.close();
  }


  SECTION("..:: PSM cbor map ::..", "[cborpsm]")
  {
    pappso::UiMonitorVoid monitor;

    QFile cbor_file("append.cbor");
    cbor_file.open(QIODevice::ReadOnly);


    QFile fileods("test2.ods");
    OdsDocWriter writer(&fileods);


    CborTest cbor_pappso(writer);
    cbor_pappso.readCbor(&cbor_file, monitor);
    // xic_writer.write(xic);
    writer.close();
    fileods.close();
  }
}
