#pragma once

#include <QDebug>
#include <pappsomspp/msfile/msfileaccessor.h>
#include <pappsomspp/pappsoexception.h>
#include <iostream>
#include <iomanip>
#include <odsstream/odsdocwriter.h>
#include <QJsonDocument>
#include <pappsomspp/psm/peptidespectrummatch.h>
#include <pappsomspp/psm/peptideisotopespectrummatch.h>
#include <pappsomspp/amino_acid/aastringcodec.h>

using namespace pappso;

MassSpectrum readMgf(const QString &filename);

QualifiedMassSpectrum readQualifiedMassSpectrumMgf(const QString &filename);


class XicOdsWriter
{
  public:
  XicOdsWriter(CalcWriterInterface &output) : _output(output)
  {
    _output.writeCell("rt");
    _output.writeCell("intensity");
    _output.writeLine();
  };

  void
  write(const Trace &xic)
  {
    auto it = xic.begin();
    while(it != xic.end())
      {

        _output.writeCell(it->x);
        _output.writeCell(it->y);
        _output.writeLine();
        it++;
      }
  };

  private:
  CalcWriterInterface &_output;
};

bool compareTextFiles(const QString &file1, const QString &file2);

std::vector<std::size_t> getMapKeys(const std::map<std::size_t, std::size_t> &map_table);
std::vector<std::size_t> getMapValues(const std::map<std::size_t, std::size_t> &map_table);


void writeJsonTrace(const QString &filepath, Trace &xic);

void writeJsonPsm(const QString &filepath,
                  const MassSpectrum &mass_spectrum,
                  const pappso::PeptideSpectrumMatch &psm);

void writeJsonPsmIsotope(const QString &filein,
                         const MassSpectrum &mass_spectrum,
                         const pappso::PeptideIsotopeSpectrumMatch &psm);


void writeJsonCodeList(const QString &filein,
                       const std::vector<uint32_t> code_list,
                       const pappso::AaStringCodec &aa_codec);
