/**
 * \file pappsomspp/processing/cbor/psm/evalscan/psmspecglob.h
 * \date 19/07/2025
 * \author Olivier Langella
 * \brief compute specglob alignment on scan's PSM
 */

/*******************************************************************************
 * Copyright (c) 2025 Olivier Langella <Olivier.Langella@universite-paris-saclay.fr>.
 *
 * This file is part of PAPPSOms-tools.
 *
 *     PAPPSOms-tools is free software: you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation, either version 3 of the License, or
 *     (at your option) any later version.
 *
 *     PAPPSOms-tools is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with PAPPSOms-tools.  If not, see <http://www.gnu.org/licenses/>.
 *
 ******************************************************************************/
#pragma once

#include "../psmfilescanprocessandcopy.h"
#include "../../../../amino_acid/aacode.h"
#include <QJsonObject>

namespace pappso
{
namespace cbor
{
namespace psm
{


/**
 * @todo write docs
 */
class PsmSpecPeptidOms : public PsmFileScanProcessAndCopy
{
  public:
  /**
   * Default constructor
   */
  PsmSpecPeptidOms(std::size_t buffer_scan_size,
                   CborStreamWriter *cbor_output_p,
                   const QJsonObject &parameters);

  /**
   * Destructor
   */
  virtual ~PsmSpecPeptidOms();


  void filterMassSpectrum(pappso::MassSpectrum &mass_spectrum) const;

  const pappso::AaCode &getAaCode() const;

  protected:
  CborScanMapBase *newCborScanMap() override;

  void parameterMapReady(pappso::UiMonitorInterface &monitor) override;

  protected:
  pappso::AaCode m_aaCode;
  QJsonObject m_specpeptidomsParameters;
  pappso::PrecisionPtr m_fragmentTolerance;
  double m_minimumMz;
  std::size_t m_nMostIntense;
  bool m_deisotope = true;
};


class PsmSpecPeptidOmsScan : public CborScanMapBase
{
  public:
  /**
   * Default constructor
   */
  PsmSpecPeptidOmsScan(const PsmSpecPeptidOms &psm_specpeptidoms,
                       pappso::PrecisionPtr fragment_tolerance);

  /**
   * Destructor
   */
  virtual ~PsmSpecPeptidOmsScan();

  protected:
  void process() override;

  private:
  const PsmSpecPeptidOms *mp_psmSpecPeptidOms;
  pappso::PrecisionPtr m_fragmentTolerance;
  bool m_checkMutations = false;
};
} // namespace psm
} // namespace cbor
} // namespace pappso
