/*
 * Copyright (c) 2025 Aurélien Berthier
 * <aurelien.berthier@ls2n.fr>
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "scorevalues.h"

namespace pappso
{
namespace specpeptidoms
{
ScoreValues::ScoreValues()
{
  m_scoreTable[(uint8_t)ScoreType::foundDouble] = 10;
  m_scoreTable[(uint8_t)ScoreType::found] = 7;
  m_scoreTable[(uint8_t)ScoreType::foundShiftDouble] = -6;
  m_scoreTable[(uint8_t)ScoreType::foundShift] = -8;
  m_scoreTable[(uint8_t)ScoreType::notFound] = -4;
  m_scoreTable[(uint8_t)ScoreType::init] = -19;
}

ScoreValues::ScoreValues(const ScoreValues &other)
{
  std::copy(other.m_scoreTable, other.m_scoreTable + 10, m_scoreTable);
}

ScoreValues::~ScoreValues()
{
}

int
ScoreValues::get(ScoreType type)
{
  return m_scoreTable[(std::uint8_t)type];
}

const ScoreValues &
ScoreValues::operator=(const ScoreValues &other)
{
  std::copy(other.m_scoreTable, other.m_scoreTable + 10, m_scoreTable);
  return *this;
}

} // namespace specpeptidoms
} // namespace pappso
