#import "template.typ": *

#show: doc => conf(
  authors: (
    (
      name: "Olivier Langella",
    ),
  ),
  toc: true,
  lang: "en",
  font: "Roboto",
  date: "05/07/2025",
  years: (2025),
  version: "0.1",
  "PSM CBOR format documentation",
  doc
)

= Introduction

PSM CBOR file is designed to record any PSM (peptide spectrum match) in a compact binary file, easy to manipulate, versatile, extendable.
This file is used as a stream in any condition, allowing the users to use unix pipes, compression algorithms, network transparency.

This way, from a DDA identification engine search result converted in PSM CBOR, any process can be added :
- Feature computations
- Prediction process (retention times, ion mobility, MS2 prediction...)
- Rescoring
- Filtering

= psm CBOR format

It could be something like that :
#let code_psm = read("psmcbor.json")
#code-block(code_psm, "json", title: "PSM cbor file format")


