//
// File: test_fragmentationcid.cpp
// Created by: Olivier Langella
// Created on: 10/3/2015
//
/*******************************************************************************
 * Copyright (c) 2015 Olivier Langella <Olivier.Langella@moulon.inra.fr>.
 *
 * This file is part of the PAPPSOms++ library.
 *
 *     PAPPSOms++ is free software: you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation, either version 3 of the License, or
 *     (at your option) any later version.
 *
 *     PAPPSOms++ is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with PAPPSOms++.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Contributors:
 *     Olivier Langella <Olivier.Langella@moulon.inra.fr> - initial API and
 *implementation
 ******************************************************************************/


// ./tests/catch2-only-tests [fragmentationcid] -s

#include <catch2/catch_test_macros.hpp>
#include <catch2/catch_approx.hpp>


#include <pappsomspp/pappsoexception.h>
#include <pappsomspp/mzrange.h>

#include <pappsomspp/peptide/peptidefragmentionlistbase.h>
#include <iostream>
#include <QDebug>
#include <QString>

using namespace pappso;
using namespace std;


TEST_CASE("fragmentationcid test suite.", "[fragmentationcid]")
{
  // Set the debugging message formatting pattern.
  qSetMessagePattern(QString("%{file}@%{line}, %{function}(): %{message}"));

  SECTION("..:: test fragmentationcid ::..", "[fragmentationcid]")
  {
    std::cout << std::endl << "..:: test ion direction ::.." << std::endl;
    REQUIRE(getPeptideIonDirection(PeptideIon::b) == PeptideDirection::Nter);
    REQUIRE(getPeptideIonDirection(PeptideIon::bstar) == PeptideDirection::Nter);
    REQUIRE(getPeptideIonDirection(PeptideIon::bo) == PeptideDirection::Nter);
    REQUIRE(getPeptideIonDirection(PeptideIon::a) == PeptideDirection::Nter);
    REQUIRE(getPeptideIonDirection(PeptideIon::astar) == PeptideDirection::Nter);
    REQUIRE(getPeptideIonDirection(PeptideIon::ao) == PeptideDirection::Nter);
    REQUIRE(getPeptideIonDirection(PeptideIon::bp) == PeptideDirection::Nter);
    REQUIRE(getPeptideIonDirection(PeptideIon::c) == PeptideDirection::Nter);
    REQUIRE(getPeptideIonDirection(PeptideIon::y) == PeptideDirection::Cter);
    REQUIRE(getPeptideIonDirection(PeptideIon::ystar) == PeptideDirection::Cter);
    REQUIRE(getPeptideIonDirection(PeptideIon::yo) == PeptideDirection::Cter);
    REQUIRE(getPeptideIonDirection(PeptideIon::z) == PeptideDirection::Cter);
    REQUIRE(getPeptideIonDirection(PeptideIon::yp) == PeptideDirection::Cter);
    REQUIRE(getPeptideIonDirection(PeptideIon::x) == PeptideDirection::Cter);

    INFO("..:: peptide fragment init ::..");
    // http://proteus.moulon.inra.fr/w2dpage/proticdb/angular/#/peptide_hits/10053478
    Peptide peptide("DSTIPDKQITASSFYK");
    std::list<PeptideIon> cid_ion = PeptideFragmentIonListBase::getCIDionList();
    PeptideFragmentIonListBase frag_cid(peptide.makePeptideSp(), cid_ion);

    std::list<PeptideFragmentIonSp>::const_iterator it = frag_cid.begin();

    while(it != frag_cid.end())
      {
        // unsigned int size = it->get()->size();
        QString name = it->get()->getPeptideIonName();
        std::cout << it->get()->getSequence().toStdString() << " "
                  << it->get()->getPeptideIonName().toStdString() << " " << it->get()->getMz(1)
                  << " " << it->get()->getFormula(1).toStdString() << std::endl;
        it++;
      }

    auto ion_y_list = frag_cid.getPeptideFragmentIonSp(PeptideIon::y);

    for(auto &fragment_ion_sp : ion_y_list)
      {
        std::size_t ion_number = fragment_ion_sp.get()->size();
        switch(ion_number)
          {
            case 1:
              REQUIRE(Catch::Approx(fragment_ion_sp.get()->getMass()) == 146.1055277001);
              break;
            case 2:
              REQUIRE(Catch::Approx(fragment_ion_sp.get()->getMass()) == 309.1688562342);
              break;
            case 3:
              REQUIRE(Catch::Approx(fragment_ion_sp.get()->getMass()) == 456.2372701487);
              break;
            case 4:
              REQUIRE(Catch::Approx(fragment_ion_sp.get()->getMass()) == 543.2692985538);
              break;
            case 5:
              REQUIRE(Catch::Approx(fragment_ion_sp.get()->getMass()) == 630.301326959);
              break;
            default:
              break;
          }
      }
      
      
    auto ion_b_list = frag_cid.getPeptideFragmentIonSp(PeptideIon::b);

    for(auto &fragment_ion_sp : ion_b_list)
      {
        std::size_t ion_number = fragment_ion_sp.get()->size();
        switch(ion_number)
          {
            case 1:
              REQUIRE(Catch::Approx(fragment_ion_sp.get()->getMass()) == 115.0269430247);
              break;
            case 2:
              REQUIRE(Catch::Approx(fragment_ion_sp.get()->getMass()) == 202.0589714298);
              break;
            case 3:
              REQUIRE(Catch::Approx(fragment_ion_sp.get()->getMass()) == 303.1066498994);
              break;
            case 4:
              REQUIRE(Catch::Approx(fragment_ion_sp.get()->getMass()) == 416.1907138784);
              break;
            case 5:
              REQUIRE(Catch::Approx(fragment_ion_sp.get()->getMass()) == 513.2434777285);
              break;
            default:
              break;
          }
      }
  }
}
