/**
 * \file pappsomspp/psm/specglob/specglobspectrum.h
 * \date 30/09/2022
 * \author PRUNIER Grégoire
 * \brief base class to build specific spectrum for SpecGlob
 */

/*******************************************************************************
 * Copyright (c) 2022 Olivier Langella <Olivier.Langella@u-psud.fr>.
 *
 * This file is part of PAPPSOms-tools.
 *
 *     PAPPSOms-tools is free software: you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation, either version 3 of the License, or
 *     (at your option) any later version.
 *
 *     PAPPSOms-tools is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with PAPPSOms-tools.  If not, see <http://www.gnu.org/licenses/>.
 *
 ******************************************************************************/

#pragma once


namespace pappso
{
/**
 * @todo write docs
 */
class PMSPP_LIB_DECL SpecGlobSpectrum
{
  public:
  /**
   * Default constructor
   */
  SpecGlobSpectrum();

  /**
   * Destructor
   */
  virtual ~SpecGlobSpectrum();


  private:
  // Attributes

  /**
   * A Map that contain couple of double corresponding to m/z , Intensity
   */
  std::map<double, double> _peakList;

  /**
   * The list of the mass to simplify filling matrix
   */
  std::list<double> _massList;

  /**
   * The mass of the peptide. It can be from precursor for experimental or from
   * the peptide sequence for theoretical
   */
  double _mainMass;
};
