/**
 * \file pappsomspp/amino_acid/aacode.cpp
 * \date 03/05/2023
 * \author Olivier Langella
 * \brief give an integer code to each amino acid
 */

/*******************************************************************************
 * Copyright (c) 2023 Olivier Langella <Olivier.Langella@u-psud.fr>.
 *
 * This file is part of PAPPSOms-tools.
 *
 *     PAPPSOms-tools is free software: you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation, either version 3 of the License, or
 *     (at your option) any later version.
 *
 *     PAPPSOms-tools is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with PAPPSOms-tools.  If not, see <http://www.gnu.org/licenses/>.
 *
 ******************************************************************************/

#include "aacode.h"

using namespace pappso;

AaCode::AaCode()
{
  m_asciiTable.resize(90);

  m_aaCollection.push_back(Aa('A'));
  m_aaCollection.push_back(Aa('C'));
  m_aaCollection.push_back(Aa('D'));
  m_aaCollection.push_back(Aa('E'));
  m_aaCollection.push_back(Aa('F'));
  m_aaCollection.push_back(Aa('G'));
  m_aaCollection.push_back(Aa('H'));
  m_aaCollection.push_back(Aa('I'));
  m_aaCollection.push_back(Aa('K'));
  m_aaCollection.push_back(Aa('M'));
  m_aaCollection.push_back(Aa('N'));
  m_aaCollection.push_back(Aa('P'));
  m_aaCollection.push_back(Aa('Q'));
  m_aaCollection.push_back(Aa('R'));
  m_aaCollection.push_back(Aa('S'));
  m_aaCollection.push_back(Aa('T'));
  m_aaCollection.push_back(Aa('V'));
  m_aaCollection.push_back(Aa('W'));
  m_aaCollection.push_back(Aa('Y'));


  std::sort(
    m_aaCollection.begin(),
    m_aaCollection.end(),
    [](const Aa &aa1, const Aa &aa2) { return aa1.getMass() < aa2.getMass(); });

  std::size_t n = 1;
  for(const Aa &aa : m_aaCollection)
    {
      m_asciiTable[aa.getLetter()] = n;
      n++;
    }
  m_asciiTable['L'] = m_asciiTable['I'];
}

AaCode::~AaCode()
{
}

uint8_t
pappso::AaCode::getAaCode(char aa_letter)
{
  return m_asciiTable[aa_letter];
}
