//
// File: test_hyperscore.cpp
// Created by: Olivier Langella
// Created on: 13/3/2015
//
/*******************************************************************************
 * Copyright (c) 2015 Olivier Langella <Olivier.Langella@moulon.inra.fr>.
 *
 * This file is part of the PAPPSOms++ library.
 *
 *     PAPPSOms++ is free software: you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation, either version 3 of the License, or
 *     (at your option) any later version.
 *
 *     PAPPSOms++ is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with PAPPSOms++.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Contributors:
 *     Olivier Langella <Olivier.Langella@moulon.inra.fr> - initial API and
 *implementation
 ******************************************************************************/


#include <pappsomspp/mzrange.h>
#include <pappsomspp/peptide/peptidenaturalisotopelist.h>
#include <pappsomspp/peptide/peptidefragmentionlistbase.h>
#include <pappsomspp/massspectrum/massspectrum.h>
#include <pappsomspp/psm/xtandem/xtandemhyperscore.h>
#include <pappsomspp/psm/xtandem/xtandemspectrumprocess.h>
#include <pappsomspp/processing/filters/filtertandemremovec13.h>
#include <pappsomspp/processing/filters/filterresample.h>
#include <iostream>
#include <iomanip>
#include <set>
#include <vector>
#include <QDebug>
#include <QString>
#include "common.h"
#include "config.h"

using namespace pappso;
using namespace std;
// using namespace pwiz::msdata;

// make test ARGS="-V -I 16,16"

int
main()
{

  cout << endl << "..:: Test scan 15968 ::.." << endl;
  PrecisionPtr precision = PrecisionFactory::getDaltonInstance(0.02);
  std::list<PeptideIon> ion_list;
  ion_list.push_back(PeptideIon::y);
  ion_list.push_back(PeptideIon::b);


  std::vector<pair<pappso_double, pappso_double>> first_spectrum = {
    {89.0171, 1255.71}, {89.0603, 258758},  {90.0636, 12425.6},
    {91.0495, 1279.8},  {91.055, 7705.08},  {93.0703, 5502.73},
    {95.0497, 8020.64}, {95.0861, 13957.1}, {97.0653, 15931.7},
    {97.1017, 2961.08}, {98.0606, 2268.44}, {99.0446, 13088.5},
    {99.0557, 1697.84}, {99.0808, 11889.6}, {100.076, 1732.78},
    {101.06, 68738.8},  {101.071, 2485.04}, {101.096, 2808.63},
    {102.056, 5733.14}, {102.068, 52705.2}, {102.57, 1894.38},
    {103.039, 90526.6}, {103.076, 46579.7}, {104.043, 3137.48},
    {104.054, 1501.14}, {104.078, 1306.75}, {105.034, 2022.36},
    {105.07, 2004.45},  {107.071, 13896.3}, {107.086, 7528.79},
    {109.065, 5838.64}, {109.076, 5429.15}, {109.102, 13790.2},
    {110.072, 6277.51}, {111.044, 1263.75}, {111.073, 9752.98},
    {111.081, 2150.96}, {111.117, 2187.44}, {112.076, 5092.75},
    {112.087, 1946.41}, {113.06, 19609.5},  {113.096, 1460.13},
    {114.092, 11088.2}, {115.076, 31572.7}, {116.071, 2308.32},
    {116.084, 1966.57}, {117.055, 20319.6}, {117.071, 1363.91},
    {117.091, 63645.5}, {118.095, 2530.43}, {119.086, 5886.15},
    {120.081, 17588.9}, {121.065, 1837.95}, {121.086, 2645.5},
    {121.101, 11908.3}, {123.081, 9379.51}, {123.117, 9777.68},
    {124.081, 28138.2}, {124.583, 2318.93}, {125.06, 6995.67},
    {125.096, 7132.5},  {126.092, 5778.39}, {127.075, 5899.92},
    {127.112, 5491.97}, {128.071, 5093.58}, {129.055, 4217.6},
    {129.066, 5946.75}, {129.091, 7317.95}, {129.102, 6977.88},
    {130.065, 2379.79}, {130.087, 5091.96}, {131.07, 48273.6},
    {131.087, 6404.52}, {131.107, 1801.39}, {132.074, 1826.34},
    {133.086, 245602},  {133.588, 2947.25}, {134.089, 17387.1},
    {134.993, 2116.07}, {135.081, 6530.39}, {135.117, 12822.9},
    {136.076, 9739.49}, {137.096, 8168.15}, {137.133, 1995.65},
    {138.092, 1773.06}, {139.076, 6838},    {139.112, 5610.2},
    {140.095, 1929.64}, {140.107, 10021.8}, {141.091, 6473.44},
    {141.127, 1759.04}, {142.123, 2570.99}, {143.071, 2289.28},
    {143.108, 3512.4},  {143.118, 13273.3}, {144.102, 2022.77},
    {145.051, 1621.94}, {145.087, 1811.55}, {145.101, 6412.22},
    {145.123, 1565.65}, {146.094, 15363.7}, {146.595, 2046.11},
    {147.044, 1342.77}, {147.065, 8760.55}, {147.081, 1940.53},
    {147.102, 22403.3}, {147.115, 8926.49}, {149.096, 6581.73},
    {149.133, 5847.23}, {151.075, 5409.98}, {151.097, 2271.86},
    {151.112, 5583.89}, {152.108, 5696.35}, {153.091, 6418.92},
    {153.128, 2253.41}, {154.087, 1357.14}, {154.123, 25125.8},
    {155.097, 9781.48}, {155.11, 1780.95},  {156.102, 8107.66},
    {156.137, 1521.09}, {157.134, 27587.5}, {158.092, 2172.65},
    {158.117, 5618.04}, {159.101, 7098.61}, {159.116, 5979.43},
    {161.081, 1808.02}, {161.095, 1742.41}, {161.117, 6572.96},
    {161.132, 4798.3},  {163.097, 3163.79}, {163.112, 7658.69},
    {163.149, 2277.79}, {164.105, 6259.31}, {165.091, 5256.09},
    {165.128, 2644.99}, {166.054, 5869.06}, {166.123, 1603.3},
    {167.106, 1763},    {168.069, 2399.99}, {168.105, 1593.3},
    {168.138, 2041.98}, {169.086, 2146.5},  {169.1, 1865.34},
    {169.134, 7854.18}, {170.117, 24030.6}, {171.101, 2235.5},
    {171.115, 2957.3},  {171.149, 39062.5}, {172.134, 13334.8},
    {173.093, 5114.72}, {173.117, 8631.08}, {173.13, 5303.29},
    {174.112, 2742.49}, {175.097, 12538.7}, {175.119, 25183.3},
    {175.133, 7473.42}, {175.148, 2664.61}, {177.09, 2204.55},
    {177.113, 52904.4}, {177.127, 4770.5},  {178.116, 2485.74},
    {179.106, 2751.31}, {179.119, 2403.68}, {179.143, 6999.31},
    {181.122, 1902.17}, {182.154, 2802.05}, {183.101, 1776.2},
    {184.073, 5227.31}, {184.134, 6150.57}, {185.13, 5578.06},
    {185.166, 2662.32}, {187.072, 1981.55}, {187.11, 1845.93},
    {187.145, 27989},   {188.147, 1641.03}, {189.128, 1738.55},
    {190.121, 2328.53}, {191.128, 7989.35}, {192.138, 1458.81},
    {196.171, 1885.77}, {197.129, 19692.7}, {198.15, 2859.96},
    {199.127, 2262.41}, {200.238, 2525.81}, {201.125, 5841.99},
    {201.163, 1564.23}, {203.07, 1625.81},  {203.106, 2486.6},
    {203.126, 1390.75}, {205.098, 2673.08}, {205.123, 1581.69},
    {205.143, 1570.8},  {205.16, 1748.89},  {207.122, 1413.82},
    {209.116, 1608.26}, {210.149, 2769.95}, {211.147, 2665.94},
    {212.166, 2871.34}, {213.161, 1735.92}, {214.254, 7653.12},
    {215.14, 57434.9},  {215.174, 1456.18}, {216.141, 7285.48},
    {217.196, 1415.78}, {219.174, 1498.28}, {221.139, 7021.04},
    {224.202, 1453.64}, {225.124, 10115.4}, {226.181, 10444.2},
    {226.216, 3078.76}, {227.179, 2551.16}, {228.269, 6800.2},
    {229.118, 4647.04}, {239.148, 5466.28}, {239.178, 1729},
    {241.106, 1809.45}, {243.134, 10133.7}, {243.211, 5106.94},
    {244.264, 26424.2}, {245.138, 2070.28}, {245.268, 2782.22},
    {247.17, 2311.67},  {249.186, 2303.04}, {254.152, 1745.34},
    {257.191, 2580.59}, {259.206, 5775.87}, {261.222, 6808.63},
    {264.197, 3247.49}, {271.175, 2850.4},  {272.161, 5428.97},
    {272.295, 11611},   {273.186, 11948.8}, {273.3, 2099.81},
    {275.2, 16706.5},   {276.203, 2150.23}, {276.232, 2009.9},
    {277.187, 2346.88}, {277.216, 36167.8}, {278.219, 4981.19},
    {278.249, 7893.56}, {279.231, 16870.7}, {280.233, 2530.57},
    {282.145, 1712.36}, {283.175, 7353.41}, {287.055, 2417.37},
    {288.201, 2296.07}, {288.289, 32807.4}, {289.181, 6561.88},
    {289.293, 8928.77}, {290.214, 7618.13}, {291.194, 14399.3},
    {292.227, 14582.9}, {293.21, 21588.3},  {294.214, 2603.64},
    {294.243, 28819.8}, {296.23, 1793.52},  {296.26, 9409.71},
    {304.163, 1888.84}, {304.286, 10249.6}, {305.289, 2610.17},
    {306.207, 2676.59}, {307.239, 2788.35}, {308.16, 6271},
    {308.189, 111642},  {308.223, 12250.2}, {309.162, 2222.38},
    {309.191, 2327.98}, {309.221, 2689.04}, {310.239, 13792.8},
    {312.218, 1833.09}, {316.321, 35943.9}, {326.171, 18416.8},
    {326.233, 1699.29}, {331.08, 17702.9},  {360.884, 1547.19},
    {391.232, 2437.46}, {401.288, 20657.7}, {402.293, 2749.24},
    {419.191, 1795.47}, {424.305, 2363.22}, {447.361, 1858.47},
    {499.291, 2152.42}, {516.315, 8476.86}, {595.427, 2431.63},
    {596.437, 14625.5}, {615.383, 11218.2}, {637.414, 205655},
    {638.419, 84439.5}, {639.426, 22234.6}, {639.742, 1605.19},
    {661.367, 9815.55}, {760.435, 2172.92}, {762.448, 9644.32},
    {802.458, 1777.27}, {819.471, 46275.2}, {820.475, 21511},
    {821.479, 3242.61}, {865.499, 1766.79}, {932.555, 13635},
    {933.556, 6769.24}, {1033.61, 14522.8}, {1034.61, 9338.05},
    {1035.6, 2029.54}};
  std::vector<pair<pappso_double, pappso_double>> remove_isotopes = {
    {89.0171, 1255.71}, {89.0603, 258758},  {90.0636, 12425.6},
    {91.0495, 1279.8},  {91.055, 7705.08},  {93.0703, 5502.73},
    {95.0497, 8020.64}, {95.0861, 13957.1}, {97.0653, 15931.7},
    {97.1017, 2961.08}, {98.0606, 2268.44}, {99.0446, 13088.5},
    {99.0557, 1697.84}, {99.0808, 11889.6}, {100.076, 1732.78},
    {101.06, 68738.8},  {101.071, 2485.04}, {101.096, 2808.63},
    {102.056, 5733.14}, {102.068, 52705.2}, {102.57, 1894.38},
    {103.039, 90526.6}, {103.076, 46579.7}, {104.043, 3137.48},
    {104.054, 1501.14}, {104.078, 1306.75}, {105.034, 2022.36},
    {105.07, 2004.45},  {107.071, 13896.3}, {107.086, 7528.79},
    {109.065, 5838.64}, {109.076, 5429.15}, {109.102, 13790.2},
    {110.072, 6277.51}, {111.044, 1263.75}, {111.073, 9752.98},
    {111.081, 2150.96}, {111.117, 2187.44}, {112.076, 5092.75},
    {112.087, 1946.41}, {113.06, 19609.5},  {113.096, 1460.13},
    {114.092, 11088.2}, {115.076, 31572.7}, {116.071, 2308.32},
    {116.084, 1966.57}, {117.055, 20319.6}, {117.071, 1363.91},
    {117.091, 63645.5}, {118.095, 2530.43}, {119.086, 5886.15},
    {120.081, 17588.9}, {121.065, 1837.95}, {121.086, 2645.5},
    {121.101, 11908.3}, {123.081, 9379.51}, {123.117, 9777.68},
    {124.081, 28138.2}, {124.583, 2318.93}, {125.06, 6995.67},
    {125.096, 7132.5},  {126.092, 5778.39}, {127.075, 5899.92},
    {127.112, 5491.97}, {128.071, 5093.58}, {129.055, 4217.6},
    {129.066, 5946.75}, {129.091, 7317.95}, {129.102, 6977.88},
    {130.065, 2379.79}, {130.087, 5091.96}, {131.07, 48273.6},
    {131.087, 6404.52}, {131.107, 1801.39}, {132.074, 1826.34},
    {133.086, 245602},  {133.588, 2947.25}, {134.089, 17387.1},
    {134.993, 2116.07}, {135.081, 6530.39}, {135.117, 12822.9},
    {136.076, 9739.49}, {137.096, 8168.15}, {137.133, 1995.65},
    {138.092, 1773.06}, {139.076, 6838},    {139.112, 5610.2},
    {140.095, 1929.64}, {140.107, 10021.8}, {141.091, 6473.44},
    {141.127, 1759.04}, {142.123, 2570.99}, {143.071, 2289.28},
    {143.108, 3512.4},  {143.118, 13273.3}, {144.102, 2022.77},
    {145.051, 1621.94}, {145.087, 1811.55}, {145.101, 6412.22},
    {145.123, 1565.65}, {146.094, 15363.7}, {146.595, 2046.11},
    {147.044, 1342.77}, {147.065, 8760.55}, {147.081, 1940.53},
    {147.102, 22403.3}, {147.115, 8926.49}, {149.096, 6581.73},
    {149.133, 5847.23}, {151.075, 5409.98}, {151.097, 2271.86},
    {151.112, 5583.89}, {152.108, 5696.35}, {153.091, 6418.92},
    {153.128, 2253.41}, {154.087, 1357.14}, {154.123, 25125.8},
    {155.097, 9781.48}, {155.11, 1780.95},  {156.102, 8107.66},
    {156.137, 1521.09}, {157.134, 27587.5}, {158.092, 2172.65},
    {158.117, 5618.04}, {159.101, 7098.61}, {159.116, 5979.43},
    {161.081, 1808.02}, {161.095, 1742.41}, {161.117, 6572.96},
    {161.132, 4798.3},  {163.097, 3163.79}, {163.112, 7658.69},
    {163.149, 2277.79}, {164.105, 6259.31}, {165.091, 5256.09},
    {165.128, 2644.99}, {166.054, 5869.06}, {166.123, 1603.3},
    {167.106, 1763},    {168.069, 2399.99}, {168.105, 1593.3},
    {168.138, 2041.98}, {169.086, 2146.5},  {169.1, 1865.34},
    {169.134, 7854.18}, {170.117, 24030.6}, {171.101, 2235.5},
    {171.115, 2957.3},  {171.149, 39062.5}, {172.134, 13334.8},
    {173.093, 5114.72}, {173.117, 8631.08}, {173.13, 5303.29},
    {174.112, 2742.49}, {175.097, 12538.7}, {175.119, 25183.3},
    {175.133, 7473.42}, {175.148, 2664.61}, {177.09, 2204.55},
    {177.113, 52904.4}, {177.127, 4770.5},  {178.116, 2485.74},
    {179.106, 2751.31}, {179.119, 2403.68}, {179.143, 6999.31},
    {181.122, 1902.17}, {182.154, 2802.05}, {183.101, 1776.2},
    {184.073, 5227.31}, {184.134, 6150.57}, {185.13, 5578.06},
    {185.166, 2662.32}, {187.072, 1981.55}, {187.11, 1845.93},
    {187.145, 27989},   {188.147, 1641.03}, {189.128, 1738.55},
    {190.121, 2328.53}, {191.128, 7989.35}, {192.138, 1458.81},
    {196.171, 1885.77}, {197.129, 19692.7}, {198.15, 2859.96},
    {199.127, 2262.41}, {201.125, 5841.99}, {203.106, 2486.6},
    {205.098, 2673.08}, {207.122, 1413.82}, {209.116, 1608.26},
    {210.149, 2769.95}, {211.147, 2665.94}, {212.166, 2871.34},
    {213.161, 1735.92}, {215.14, 57434.9},  {216.141, 7285.48},
    {217.196, 1415.78}, {219.174, 1498.28}, {221.139, 7021.04},
    {225.124, 10115.4}, {226.181, 10444.2}, {227.179, 2551.16},
    {228.269, 6800.2},  {239.148, 5466.28}, {241.106, 1809.45},
    {243.134, 10133.7}, {244.264, 26424.2}, {245.268, 2782.22},
    {247.17, 2311.67},  {249.186, 2303.04}, {254.152, 1745.34},
    {257.191, 2580.59}, {259.206, 5775.87}, {261.222, 6808.63},
    {264.197, 3247.49}, {271.175, 2850.4},  {272.295, 11611},
    {273.186, 11948.8}, {275.2, 16706.5},   {276.203, 2150.23},
    {277.216, 36167.8}, {278.249, 7893.56}, {279.231, 16870.7},
    {280.233, 2530.57}, {282.145, 1712.36}, {283.175, 7353.41},
    {287.055, 2417.37}, {288.289, 32807.4}, {289.293, 8928.77},
    {290.214, 7618.13}, {291.194, 14399.3}, {292.227, 14582.9},
    {293.21, 21588.3},  {294.243, 28819.8}, {296.26, 9409.71},
    {304.286, 10249.6}, {306.207, 2676.59}, {308.16, 6271},
    {308.189, 111642},  {309.221, 2689.04}, {310.239, 13792.8},
    {312.218, 1833.09}, {316.321, 35943.9}, {326.171, 18416.8},
    {331.08, 17702.9},  {360.884, 1547.19}, {391.232, 2437.46},
    {401.288, 20657.7}, {402.293, 2749.24}, {419.191, 1795.47},
    {424.305, 2363.22}, {447.361, 1858.47}, {499.291, 2152.42},
    {516.315, 8476.86}, {595.427, 2431.63}, {596.437, 14625.5},
    {615.383, 11218.2}, {637.414, 205655},  {638.419, 84439.5},
    {639.426, 22234.6}, {661.367, 9815.55}, {760.435, 2172.92},
    {762.448, 9644.32}, {802.458, 1777.27}, {819.471, 46275.2},
    {820.475, 21511},   {821.479, 3242.61}, {865.499, 1766.79},
    {932.555, 13635},   {933.556, 6769.24}, {1033.61, 14522.8},
    {1034.61, 9338.05}, {1035.6, 2029.54}};
  std::vector<pair<pappso_double, pappso_double>> remove_parent = {
    {89.0171, 1255.71}, {89.0603, 258758},  {90.0636, 12425.6},
    {91.0495, 1279.8},  {91.055, 7705.08},  {93.0703, 5502.73},
    {95.0497, 8020.64}, {95.0861, 13957.1}, {97.0653, 15931.7},
    {97.1017, 2961.08}, {98.0606, 2268.44}, {99.0446, 13088.5},
    {99.0557, 1697.84}, {99.0808, 11889.6}, {100.076, 1732.78},
    {101.06, 68738.8},  {101.071, 2485.04}, {101.096, 2808.63},
    {102.056, 5733.14}, {102.068, 52705.2}, {102.57, 1894.38},
    {103.039, 90526.6}, {103.076, 46579.7}, {104.043, 3137.48},
    {104.054, 1501.14}, {104.078, 1306.75}, {105.034, 2022.36},
    {105.07, 2004.45},  {107.071, 13896.3}, {107.086, 7528.79},
    {109.065, 5838.64}, {109.076, 5429.15}, {109.102, 13790.2},
    {110.072, 6277.51}, {111.044, 1263.75}, {111.073, 9752.98},
    {111.081, 2150.96}, {111.117, 2187.44}, {112.076, 5092.75},
    {112.087, 1946.41}, {113.06, 19609.5},  {113.096, 1460.13},
    {114.092, 11088.2}, {115.076, 31572.7}, {116.071, 2308.32},
    {116.084, 1966.57}, {117.055, 20319.6}, {117.071, 1363.91},
    {117.091, 63645.5}, {118.095, 2530.43}, {119.086, 5886.15},
    {120.081, 17588.9}, {121.065, 1837.95}, {121.086, 2645.5},
    {121.101, 11908.3}, {123.081, 9379.51}, {123.117, 9777.68},
    {124.081, 28138.2}, {124.583, 2318.93}, {125.06, 6995.67},
    {125.096, 7132.5},  {126.092, 5778.39}, {127.075, 5899.92},
    {127.112, 5491.97}, {128.071, 5093.58}, {129.055, 4217.6},
    {129.066, 5946.75}, {129.091, 7317.95}, {129.102, 6977.88},
    {130.065, 2379.79}, {130.087, 5091.96}, {131.07, 48273.6},
    {131.087, 6404.52}, {131.107, 1801.39}, {132.074, 1826.34},
    {133.086, 245602},  {133.588, 2947.25}, {134.089, 17387.1},
    {134.993, 2116.07}, {135.081, 6530.39}, {135.117, 12822.9},
    {136.076, 9739.49}, {137.096, 8168.15}, {137.133, 1995.65},
    {138.092, 1773.06}, {139.076, 6838},    {139.112, 5610.2},
    {140.095, 1929.64}, {140.107, 10021.8}, {141.091, 6473.44},
    {141.127, 1759.04}, {142.123, 2570.99}, {143.071, 2289.28},
    {143.108, 3512.4},  {143.118, 13273.3}, {144.102, 2022.77},
    {145.051, 1621.94}, {145.087, 1811.55}, {145.101, 6412.22},
    {145.123, 1565.65}, {146.094, 15363.7}, {146.595, 2046.11},
    {147.044, 1342.77}, {147.065, 8760.55}, {147.081, 1940.53},
    {147.102, 22403.3}, {147.115, 8926.49}, {149.096, 6581.73},
    {149.133, 5847.23}, {151.075, 5409.98}, {151.097, 2271.86},
    {151.112, 5583.89}, {152.108, 5696.35}, {153.091, 6418.92},
    {153.128, 2253.41}, {154.087, 1357.14}, {154.123, 25125.8},
    {155.097, 9781.48}, {155.11, 1780.95},  {156.102, 8107.66},
    {156.137, 1521.09}, {157.134, 27587.5}, {158.092, 2172.65},
    {158.117, 5618.04}, {159.101, 7098.61}, {159.116, 5979.43},
    {161.081, 1808.02}, {161.095, 1742.41}, {161.117, 6572.96},
    {161.132, 4798.3},  {163.097, 3163.79}, {163.112, 7658.69},
    {163.149, 2277.79}, {164.105, 6259.31}, {165.091, 5256.09},
    {165.128, 2644.99}, {166.054, 5869.06}, {166.123, 1603.3},
    {167.106, 1763},    {168.069, 2399.99}, {168.105, 1593.3},
    {168.138, 2041.98}, {169.086, 2146.5},  {169.1, 1865.34},
    {169.134, 7854.18}, {170.117, 24030.6}, {171.101, 2235.5},
    {171.115, 2957.3},  {171.149, 39062.5}, {172.134, 13334.8},
    {173.093, 5114.72}, {173.117, 8631.08}, {173.13, 5303.29},
    {174.112, 2742.49}, {175.097, 12538.7}, {175.119, 25183.3},
    {175.133, 7473.42}, {175.148, 2664.61}, {177.09, 2204.55},
    {177.113, 52904.4}, {177.127, 4770.5},  {178.116, 2485.74},
    {179.106, 2751.31}, {179.119, 2403.68}, {179.143, 6999.31},
    {181.122, 1902.17}, {182.154, 2802.05}, {183.101, 1776.2},
    {184.073, 5227.31}, {184.134, 6150.57}, {185.13, 5578.06},
    {185.166, 2662.32}, {187.072, 1981.55}, {187.11, 1845.93},
    {187.145, 27989},   {188.147, 1641.03}, {189.128, 1738.55},
    {190.121, 2328.53}, {191.128, 7989.35}, {192.138, 1458.81},
    {196.171, 1885.77}, {197.129, 19692.7}, {198.15, 2859.96},
    {199.127, 2262.41}, {201.125, 5841.99}, {203.106, 2486.6},
    {205.098, 2673.08}, {207.122, 1413.82}, {209.116, 1608.26},
    {210.149, 2769.95}, {211.147, 2665.94}, {212.166, 2871.34},
    {213.161, 1735.92}, {215.14, 57434.9},  {216.141, 7285.48},
    {217.196, 1415.78}, {219.174, 1498.28}, {221.139, 7021.04},
    {225.124, 10115.4}, {226.181, 10444.2}, {227.179, 2551.16},
    {228.269, 6800.2},  {239.148, 5466.28}, {241.106, 1809.45},
    {243.134, 10133.7}, {244.264, 26424.2}, {245.268, 2782.22},
    {247.17, 2311.67},  {249.186, 2303.04}, {254.152, 1745.34},
    {257.191, 2580.59}, {259.206, 5775.87}, {261.222, 6808.63},
    {264.197, 3247.49}, {271.175, 2850.4},  {272.295, 11611},
    {273.186, 11948.8}, {275.2, 16706.5},   {276.203, 2150.23},
    {277.216, 36167.8}, {278.249, 7893.56}, {279.231, 16870.7},
    {280.233, 2530.57}, {282.145, 1712.36}, {283.175, 7353.41},
    {287.055, 2417.37}, {288.289, 32807.4}, {289.293, 8928.77},
    {290.214, 7618.13}, {291.194, 14399.3}, {292.227, 14582.9},
    {293.21, 21588.3},  {294.243, 28819.8}, {296.26, 9409.71},
    {304.286, 10249.6}, {306.207, 2676.59}, {308.16, 6271},
    {308.189, 111642},  {309.221, 2689.04}, {310.239, 13792.8},
    {312.218, 1833.09}, {316.321, 35943.9}, {326.171, 18416.8},
    {331.08, 17702.9},  {360.884, 1547.19}, {391.232, 2437.46},
    {401.288, 20657.7}, {402.293, 2749.24}, {419.191, 1795.47},
    {424.305, 2363.22}, {447.361, 1858.47}, {499.291, 2152.42},
    {516.315, 8476.86}, {595.427, 2431.63}, {596.437, 14625.5},
    {615.383, 11218.2}, {639.426, 22234.6}, {661.367, 9815.55},
    {760.435, 2172.92}, {762.448, 9644.32}, {802.458, 1777.27},
    {819.471, 46275.2}, {820.475, 21511},   {821.479, 3242.61},
    {865.499, 1766.79}, {932.555, 13635},   {933.556, 6769.24},
    {1033.61, 14522.8}, {1034.61, 9338.05}, {1035.6, 2029.54}};
  std::vector<pair<pappso_double, pappso_double>> remove_low_masses = {
    {151.075, 5409.98}, {151.097, 2271.86}, {151.112, 5583.89},
    {152.108, 5696.35}, {153.091, 6418.92}, {153.128, 2253.41},
    {154.087, 1357.14}, {154.123, 25125.8}, {155.097, 9781.48},
    {155.11, 1780.95},  {156.102, 8107.66}, {156.137, 1521.09},
    {157.134, 27587.5}, {158.092, 2172.65}, {158.117, 5618.04},
    {159.101, 7098.61}, {159.116, 5979.43}, {161.081, 1808.02},
    {161.095, 1742.41}, {161.117, 6572.96}, {161.132, 4798.3},
    {163.097, 3163.79}, {163.112, 7658.69}, {163.149, 2277.79},
    {164.105, 6259.31}, {165.091, 5256.09}, {165.128, 2644.99},
    {166.054, 5869.06}, {166.123, 1603.3},  {167.106, 1763},
    {168.069, 2399.99}, {168.105, 1593.3},  {168.138, 2041.98},
    {169.086, 2146.5},  {169.1, 1865.34},   {169.134, 7854.18},
    {170.117, 24030.6}, {171.101, 2235.5},  {171.115, 2957.3},
    {171.149, 39062.5}, {172.134, 13334.8}, {173.093, 5114.72},
    {173.117, 8631.08}, {173.13, 5303.29},  {174.112, 2742.49},
    {175.097, 12538.7}, {175.119, 25183.3}, {175.133, 7473.42},
    {175.148, 2664.61}, {177.09, 2204.55},  {177.113, 52904.4},
    {177.127, 4770.5},  {178.116, 2485.74}, {179.106, 2751.31},
    {179.119, 2403.68}, {179.143, 6999.31}, {181.122, 1902.17},
    {182.154, 2802.05}, {183.101, 1776.2},  {184.073, 5227.31},
    {184.134, 6150.57}, {185.13, 5578.06},  {185.166, 2662.32},
    {187.072, 1981.55}, {187.11, 1845.93},  {187.145, 27989},
    {188.147, 1641.03}, {189.128, 1738.55}, {190.121, 2328.53},
    {191.128, 7989.35}, {192.138, 1458.81}, {196.171, 1885.77},
    {197.129, 19692.7}, {198.15, 2859.96},  {199.127, 2262.41},
    {201.125, 5841.99}, {203.106, 2486.6},  {205.098, 2673.08},
    {207.122, 1413.82}, {209.116, 1608.26}, {210.149, 2769.95},
    {211.147, 2665.94}, {212.166, 2871.34}, {213.161, 1735.92},
    {215.14, 57434.9},  {216.141, 7285.48}, {217.196, 1415.78},
    {219.174, 1498.28}, {221.139, 7021.04}, {225.124, 10115.4},
    {226.181, 10444.2}, {227.179, 2551.16}, {228.269, 6800.2},
    {239.148, 5466.28}, {241.106, 1809.45}, {243.134, 10133.7},
    {244.264, 26424.2}, {245.268, 2782.22}, {247.17, 2311.67},
    {249.186, 2303.04}, {254.152, 1745.34}, {257.191, 2580.59},
    {259.206, 5775.87}, {261.222, 6808.63}, {264.197, 3247.49},
    {271.175, 2850.4},  {272.295, 11611},   {273.186, 11948.8},
    {275.2, 16706.5},   {276.203, 2150.23}, {277.216, 36167.8},
    {278.249, 7893.56}, {279.231, 16870.7}, {280.233, 2530.57},
    {282.145, 1712.36}, {283.175, 7353.41}, {287.055, 2417.37},
    {288.289, 32807.4}, {289.293, 8928.77}, {290.214, 7618.13},
    {291.194, 14399.3}, {292.227, 14582.9}, {293.21, 21588.3},
    {294.243, 28819.8}, {296.26, 9409.71},  {304.286, 10249.6},
    {306.207, 2676.59}, {308.16, 6271},     {308.189, 111642},
    {309.221, 2689.04}, {310.239, 13792.8}, {312.218, 1833.09},
    {316.321, 35943.9}, {326.171, 18416.8}, {331.08, 17702.9},
    {360.884, 1547.19}, {391.232, 2437.46}, {401.288, 20657.7},
    {402.293, 2749.24}, {419.191, 1795.47}, {424.305, 2363.22},
    {447.361, 1858.47}, {499.291, 2152.42}, {516.315, 8476.86},
    {595.427, 2431.63}, {596.437, 14625.5}, {615.383, 11218.2},
    {639.426, 22234.6}, {661.367, 9815.55}, {760.435, 2172.92},
    {762.448, 9644.32}, {802.458, 1777.27}, {819.471, 46275.2},
    {820.475, 21511},   {821.479, 3242.61}, {865.499, 1766.79},
    {932.555, 13635},   {933.556, 6769.24}, {1033.61, 14522.8},
    {1034.61, 9338.05}, {1035.6, 2029.54}};
  std::vector<pair<pappso_double, pappso_double>> dynamic_range = {
    {151.075, 4.84583}, {151.097, 2.03496}, {151.112, 5.00161},
    {152.108, 5.10235}, {153.091, 5.74957}, {153.128, 2.01843},
    {154.087, 1.21562}, {154.123, 22.5057}, {155.097, 8.76148},
    {155.11, 1.59524},  {156.102, 7.26221}, {156.137, 1.36247},
    {157.134, 24.7108}, {158.092, 1.94609}, {158.117, 5.0322},
    {159.101, 6.35838}, {159.116, 5.35591}, {161.081, 1.61948},
    {161.095, 1.56072}, {161.117, 5.88754}, {161.132, 4.29795},
    {163.097, 2.83387}, {163.112, 6.86005}, {163.149, 2.04027},
    {164.105, 5.6066},  {165.091, 4.70799}, {165.128, 2.36918},
    {166.054, 5.25704}, {166.123, 1.43611}, {167.106, 1.57916},
    {168.069, 2.14972}, {168.105, 1.42716}, {168.138, 1.82905},
    {169.086, 1.92267}, {169.1, 1.67083},   {169.134, 7.03516},
    {170.117, 21.5247}, {171.101, 2.00239}, {171.115, 2.64892},
    {171.149, 34.9891}, {172.134, 11.9443}, {173.093, 4.58136},
    {173.117, 7.73104}, {173.13, 4.75028},  {174.112, 2.45651},
    {175.097, 11.2311}, {175.119, 22.5572}, {175.133, 6.6941},
    {175.148, 2.38675}, {177.09, 1.97466},  {177.113, 47.3876},
    {177.127, 4.27304}, {178.116, 2.22653}, {179.106, 2.46441},
    {179.119, 2.15303}, {179.143, 6.26943}, {181.122, 1.70381},
    {182.154, 2.50986}, {183.101, 1.59098}, {184.073, 4.68222},
    {184.134, 5.5092},  {185.13, 4.99639},  {185.166, 2.3847},
    {187.072, 1.77492}, {187.11, 1.65344},  {187.145, 25.0704},
    {188.147, 1.4699},  {189.128, 1.55726}, {190.121, 2.08571},
    {191.128, 7.15624}, {192.138, 1.30669}, {196.171, 1.68912},
    {197.129, 17.6392}, {198.15, 2.56173},  {199.127, 2.02649},
    {201.125, 5.2328},  {203.106, 2.2273},  {205.098, 2.39433},
    {207.122, 1.26639}, {209.116, 1.44055}, {210.149, 2.48111},
    {211.147, 2.38794}, {212.166, 2.57192}, {213.161, 1.5549},
    {215.14, 51.4457},  {216.141, 6.52577}, {217.196, 1.26814},
    {219.174, 1.34204}, {221.139, 6.28889}, {225.124, 9.0606},
    {226.181, 9.3551},  {227.179, 2.28513}, {228.269, 6.09109},
    {239.148, 4.89627}, {241.106, 1.62076}, {243.134, 9.07701},
    {244.264, 23.6687}, {245.268, 2.49209}, {247.17, 2.07061},
    {249.186, 2.06288}, {254.152, 1.56334}, {257.191, 2.31149},
    {259.206, 5.17357}, {261.222, 6.09864}, {264.197, 2.90884},
    {271.175, 2.55317}, {272.295, 10.4002}, {273.186, 10.7028},
    {275.2, 14.9644},   {276.203, 1.92601}, {277.216, 32.3963},
    {278.249, 7.07043}, {279.231, 15.1114}, {280.233, 2.26669},
    {282.145, 1.53379}, {283.175, 6.58661}, {287.055, 2.16529},
    {288.289, 29.3863}, {289.293, 7.99769}, {290.214, 6.82373},
    {291.194, 12.8977}, {292.227, 13.0622}, {293.21, 19.3371},
    {294.243, 25.8145}, {296.26, 8.42848},  {304.286, 9.18075},
    {306.207, 2.39748}, {308.16, 5.61707},  {308.189, 100},
    {309.221, 2.40864}, {310.239, 12.3545}, {312.218, 1.64194},
    {316.321, 32.1957}, {326.171, 16.4964}, {331.08, 15.8568},
    {360.884, 1.38585}, {391.232, 2.18329}, {401.288, 18.5035},
    {402.293, 2.46255}, {419.191, 1.60824}, {424.305, 2.11679},
    {447.361, 1.66467}, {499.291, 1.92797}, {516.315, 7.59291},
    {595.427, 2.17807}, {596.437, 13.1004}, {615.383, 10.0484},
    {639.426, 19.916},  {661.367, 8.792},   {760.435, 1.94633},
    {762.448, 8.63863}, {802.458, 1.59194}, {819.471, 41.4497},
    {820.475, 19.2679}, {821.479, 2.90448}, {865.499, 1.58255},
    {932.555, 12.2131}, {933.556, 6.06335}, {1033.61, 13.0084},
    {1034.61, 8.3643},  {1035.6, 1.8179}};
  std::vector<pair<pappso_double, pappso_double>> remove_neutral = {
    {151.075, 4.84583}, {151.097, 2.03496}, {151.112, 5.00161},
    {152.108, 5.10235}, {153.091, 5.74957}, {153.128, 2.01843},
    {154.087, 1.21562}, {154.123, 22.5057}, {155.097, 8.76148},
    {155.11, 1.59524},  {156.102, 7.26221}, {156.137, 1.36247},
    {157.134, 24.7108}, {158.092, 1.94609}, {158.117, 5.0322},
    {159.101, 6.35838}, {159.116, 5.35591}, {161.081, 1.61948},
    {161.095, 1.56072}, {161.117, 5.88754}, {161.132, 4.29795},
    {163.097, 2.83387}, {163.112, 6.86005}, {163.149, 2.04027},
    {164.105, 5.6066},  {165.091, 4.70799}, {165.128, 2.36918},
    {166.054, 5.25704}, {166.123, 1.43611}, {167.106, 1.57916},
    {168.069, 2.14972}, {168.105, 1.42716}, {168.138, 1.82905},
    {169.086, 1.92267}, {169.1, 1.67083},   {169.134, 7.03516},
    {170.117, 21.5247}, {171.101, 2.00239}, {171.115, 2.64892},
    {171.149, 34.9891}, {172.134, 11.9443}, {173.093, 4.58136},
    {173.117, 7.73104}, {173.13, 4.75028},  {174.112, 2.45651},
    {175.097, 11.2311}, {175.119, 22.5572}, {175.133, 6.6941},
    {175.148, 2.38675}, {177.09, 1.97466},  {177.113, 47.3876},
    {177.127, 4.27304}, {178.116, 2.22653}, {179.106, 2.46441},
    {179.119, 2.15303}, {179.143, 6.26943}, {181.122, 1.70381},
    {182.154, 2.50986}, {183.101, 1.59098}, {184.073, 4.68222},
    {184.134, 5.5092},  {185.13, 4.99639},  {185.166, 2.3847},
    {187.072, 1.77492}, {187.11, 1.65344},  {187.145, 25.0704},
    {188.147, 1.4699},  {189.128, 1.55726}, {190.121, 2.08571},
    {191.128, 7.15624}, {192.138, 1.30669}, {196.171, 1.68912},
    {197.129, 17.6392}, {198.15, 2.56173},  {199.127, 2.02649},
    {201.125, 5.2328},  {203.106, 2.2273},  {205.098, 2.39433},
    {207.122, 1.26639}, {209.116, 1.44055}, {210.149, 2.48111},
    {211.147, 2.38794}, {212.166, 2.57192}, {213.161, 1.5549},
    {215.14, 51.4457},  {216.141, 6.52577}, {217.196, 1.26814},
    {219.174, 1.34204}, {221.139, 6.28889}, {225.124, 9.0606},
    {226.181, 9.3551},  {227.179, 2.28513}, {228.269, 6.09109},
    {239.148, 4.89627}, {241.106, 1.62076}, {243.134, 9.07701},
    {244.264, 23.6687}, {245.268, 2.49209}, {247.17, 2.07061},
    {249.186, 2.06288}, {254.152, 1.56334}, {257.191, 2.31149},
    {259.206, 5.17357}, {261.222, 6.09864}, {264.197, 2.90884},
    {271.175, 2.55317}, {272.295, 10.4002}, {273.186, 10.7028},
    {275.2, 14.9644},   {276.203, 1.92601}, {277.216, 32.3963},
    {278.249, 7.07043}, {279.231, 15.1114}, {280.233, 2.26669},
    {282.145, 1.53379}, {283.175, 6.58661}, {287.055, 2.16529},
    {288.289, 29.3863}, {289.293, 7.99769}, {290.214, 6.82373},
    {291.194, 12.8977}, {292.227, 13.0622}, {293.21, 19.3371},
    {294.243, 25.8145}, {296.26, 8.42848},  {304.286, 9.18075},
    {306.207, 2.39748}, {308.16, 5.61707},  {308.189, 100},
    {309.221, 2.40864}, {310.239, 12.3545}, {312.218, 1.64194},
    {316.321, 32.1957}, {326.171, 16.4964}, {331.08, 15.8568},
    {360.884, 1.38585}, {391.232, 2.18329}, {401.288, 18.5035},
    {402.293, 2.46255}, {419.191, 1.60824}, {424.305, 2.11679},
    {447.361, 1.66467}, {499.291, 1.92797}, {516.315, 7.59291},
    {595.427, 2.17807}, {596.437, 13.1004}, {615.383, 10.0484},
    {639.426, 19.916},  {661.367, 8.792},   {760.435, 1.94633},
    {762.448, 8.63863}, {802.458, 1.59194}, {819.471, 41.4497},
    {820.475, 19.2679}, {821.479, 2.90448}, {865.499, 1.58255},
    {932.555, 12.2131}, {933.556, 6.06335}, {1033.61, 13.0084},
    {1034.61, 8.3643},  {1035.6, 1.8179}};
  std::vector<pair<pappso_double, pappso_double>> clean_isotopes = {
    {151.075, 4.84583}, {151.097, 2.03496}, {151.112, 5.00161},
    {152.108, 5.10235}, {153.091, 5.74957}, {153.128, 2.01843},
    {154.087, 1.21562}, {154.123, 22.5057}, {155.097, 8.76148},
    {155.11, 1.59524},  {156.102, 7.26221}, {156.137, 1.36247},
    {157.134, 24.7108}, {158.092, 1.94609}, {158.117, 5.0322},
    {159.101, 6.35838}, {159.116, 5.35591}, {161.081, 1.61948},
    {161.095, 1.56072}, {161.117, 5.88754}, {161.132, 4.29795},
    {163.097, 2.83387}, {163.112, 6.86005}, {163.149, 2.04027},
    {164.105, 5.6066},  {165.091, 4.70799}, {165.128, 2.36918},
    {166.054, 5.25704}, {166.123, 1.43611}, {167.106, 1.57916},
    {168.069, 2.14972}, {168.105, 1.42716}, {168.138, 1.82905},
    {169.086, 1.92267}, {169.1, 1.67083},   {169.134, 7.03516},
    {170.117, 21.5247}, {171.101, 2.00239}, {171.115, 2.64892},
    {171.149, 34.9891}, {172.134, 11.9443}, {173.093, 4.58136},
    {173.117, 7.73104}, {173.13, 4.75028},  {174.112, 2.45651},
    {175.097, 11.2311}, {175.119, 22.5572}, {175.133, 6.6941},
    {175.148, 2.38675}, {177.09, 1.97466},  {177.113, 47.3876},
    {177.127, 4.27304}, {178.116, 2.22653}, {179.106, 2.46441},
    {179.119, 2.15303}, {179.143, 6.26943}, {181.122, 1.70381},
    {182.154, 2.50986}, {183.101, 1.59098}, {184.073, 4.68222},
    {184.134, 5.5092},  {185.13, 4.99639},  {185.166, 2.3847},
    {187.072, 1.77492}, {187.11, 1.65344},  {187.145, 25.0704},
    {188.147, 1.4699},  {189.128, 1.55726}, {190.121, 2.08571},
    {191.128, 7.15624}, {192.138, 1.30669}, {196.171, 1.68912},
    {197.129, 17.6392}, {198.15, 2.56173},  {199.127, 2.02649},
    {201.125, 5.2328},  {203.106, 2.2273},  {205.098, 2.39433},
    {207.122, 1.26639}, {210.149, 2.48111}, {212.166, 2.57192},
    {213.161, 1.5549},  {215.14, 51.4457},  {217.196, 1.26814},
    {219.174, 1.34204}, {221.139, 6.28889}, {226.181, 9.3551},
    {228.269, 6.09109}, {239.148, 4.89627}, {241.106, 1.62076},
    {244.264, 23.6687}, {245.268, 2.49209}, {247.17, 2.07061},
    {249.186, 2.06288}, {254.152, 1.56334}, {257.191, 2.31149},
    {259.206, 5.17357}, {261.222, 6.09864}, {264.197, 2.90884},
    {272.295, 10.4002}, {273.186, 10.7028}, {275.2, 14.9644},
    {277.216, 32.3963}, {279.231, 15.1114}, {283.175, 6.58661},
    {288.289, 29.3863}, {289.293, 7.99769}, {292.227, 13.0622},
    {294.243, 25.8145}, {296.26, 8.42848},  {304.286, 9.18075},
    {306.207, 2.39748}, {308.189, 100},     {310.239, 12.3545},
    {312.218, 1.64194}, {316.321, 32.1957}, {326.171, 16.4964},
    {331.08, 15.8568},  {360.884, 1.38585}, {391.232, 2.18329},
    {401.288, 18.5035}, {419.191, 1.60824}, {424.305, 2.11679},
    {447.361, 1.66467}, {499.291, 1.92797}, {516.315, 7.59291},
    {596.437, 13.1004}, {615.383, 10.0484}, {639.426, 19.916},
    {661.367, 8.792},   {760.435, 1.94633}, {762.448, 8.63863},
    {802.458, 1.59194}, {819.471, 41.4497}, {821.479, 2.90448},
    {865.499, 1.58255}, {932.555, 12.2131}, {1033.61, 13.0084},
    {1035.6, 1.8179}};

  std::vector<pair<pappso_double, pappso_double>> remove_small = {
    {308.189, 100},     {215.14, 51.4457},  {177.113, 47.3876},
    {819.471, 41.4497}, {171.149, 34.9891}, {277.216, 32.3963},
    {316.321, 32.1957}, {288.289, 29.3863}, {294.243, 25.8145},
    {187.145, 25.0704}, {157.134, 24.7108}, {244.264, 23.6687},
    {175.119, 22.5572}, {154.123, 22.5057}, {170.117, 21.5247},
    {639.426, 19.916},  {401.288, 18.5035}, {197.129, 17.6392},
    {326.171, 16.4964}, {331.08, 15.8568},  {279.231, 15.1114},
    {275.2, 14.9644},   {596.437, 13.1004}, {292.227, 13.0622},
    {1033.61, 13.0084}, {310.239, 12.3545}, {932.555, 12.2131},
    {172.134, 11.9443}, {175.097, 11.2311}, {273.186, 10.7028},
    {272.295, 10.4002}, {615.383, 10.0484}, {226.181, 9.3551},
    {304.286, 9.18075}, {661.367, 8.792},   {155.097, 8.76148},
    {762.448, 8.63863}, {296.26, 8.42848},  {289.293, 7.99769},
    {173.117, 7.73104}, {516.315, 7.59291}, {156.102, 7.26221},
    {191.128, 7.15624}, {169.134, 7.03516}, {163.112, 6.86005},
    {175.133, 6.6941},  {283.175, 6.58661}, {159.101, 6.35838},
    {221.139, 6.28889}, {179.143, 6.26943}, {261.222, 6.09864},
    {228.269, 6.09109}, {161.117, 5.88754}, {153.091, 5.74957},
    {164.105, 5.6066},  {184.134, 5.5092},  {159.116, 5.35591},
    {166.054, 5.25704}, {201.125, 5.2328},  {259.206, 5.17357},
    {152.108, 5.10235}, {158.117, 5.0322},  {151.112, 5.00161},
    {185.13, 4.99639},  {239.148, 4.89627}, {151.075, 4.84583},
    {173.13, 4.75028},  {165.091, 4.70799}, {184.073, 4.68222},
    {173.093, 4.58136}, {161.132, 4.29795}, {177.127, 4.27304},
    {264.197, 2.90884}, {821.479, 2.90448}, {163.097, 2.83387},
    {171.115, 2.64892}, {212.166, 2.57192}, {198.15, 2.56173},
    {182.154, 2.50986}, {245.268, 2.49209}, {210.149, 2.48111},
    {179.106, 2.46441}, {174.112, 2.45651}, {306.207, 2.39748},
    {205.098, 2.39433}, {175.148, 2.38675}, {185.166, 2.3847},
    {165.128, 2.36918}, {257.191, 2.31149}, {203.106, 2.2273},
    {178.116, 2.22653}, {391.232, 2.18329}, {179.119, 2.15303},
    {168.069, 2.14972}, {424.305, 2.11679}, {190.121, 2.08571},
    {247.17, 2.07061},  {249.186, 2.06288}, {163.149, 2.04027},
    {151.097, 2.03496}};

  MassSpectrum sfirst(first_spectrum);
  sfirst.sortMz();
  MassSpectrum sremove_isotopes(remove_isotopes);
  sremove_isotopes.sortMz();
  MassSpectrum sremove_parent(remove_parent);
  sremove_parent.sortMz();
  MassSpectrum sremove_low_masses(remove_low_masses);
  sremove_low_masses.sortMz();
  MassSpectrum sdynamic_range(dynamic_range);
  sdynamic_range.sortMz();
  MassSpectrum sremove_neutral(remove_neutral);
  sremove_neutral.sortMz();
  MassSpectrum sclean_isotopes(clean_isotopes);
  sclean_isotopes.sortMz();
  MassSpectrum sremove_small(remove_small);
  sremove_small.sortMz();


  // 15968
  //    msconvert
  //    /gorgone/pappso/formation/Janvier2014/TD/mzXML/20120906_balliau_extract_1_A01_urnb-1.mzXML
  //    --filter "scanNumber 15968" --mgf
  MassSpectrum spectrum =
    readMgf(QString(CMAKE_SOURCE_DIR).append("/test/data/scan_15968.mgf"));
  if(!spectrum.equals(sfirst, precision))
    {
      cerr << "first != tandem" << endl;
      return 1;
    }
  MassSpectrum spectrum_isotopes =
    MassSpectrum(spectrum).massSpectrumFilter(FilterTandemDeisotope());
  if(!spectrum_isotopes.equals(sremove_isotopes, precision))
    {
      cerr << "spectrum_isotopes != tandem" << endl;
      // return 1;
      spectrum_isotopes = std::move(sremove_isotopes);
    }

  Peptide pep15968("EITLGFVDLLR");
  unsigned int charge_pep15968 = 2;

  // XtandemSpectrumProcess xt_spectrum_process;
  // xt_spectrum_process.setNeutralLossWindowDalton(0.02);
  MzRange parent_mass =
    MzRange(638.36934732588,
            PrecisionFactory::getDaltonInstance(2 / charge_pep15968),
            PrecisionFactory::getDaltonInstance(2 / charge_pep15968));

  MzRange parent_mass_sum =
    MzRange(pep15968.getMz(2), PrecisionFactory::getDaltonInstance(0.04));

  MassSpectrum sum = sfirst.filterSum(parent_mass_sum);
  qDebug() << " sum spectrum ";
  sum.debugPrintValues();

  MzRange parent_mass_sum_false =
    MzRange(pep15968.getMz(1), PrecisionFactory::getDaltonInstance(0.04));

  MassSpectrum sum_false = sfirst.filterSum(parent_mass_sum_false);
  qDebug() << " sum spectrum false";
  sum_false.debugPrintValues();

  MassSpectrum spectrum_parent(spectrum_isotopes);
  MassSpectrumFilterResampleRemoveMzRange(parent_mass).filter(spectrum_parent);

  if(!spectrum_parent.equals(sremove_parent, precision))
    {
      cerr << "removeParent() != tandem parent" << endl;
      return 1;
    }

  MassSpectrum spectrum_low_masses(spectrum_parent);
  FilterResampleKeepGreater(150).filter(spectrum_low_masses);
  if(!spectrum_low_masses.equals(sremove_low_masses, precision))
    {
      cerr << "spectrum_low_masses() != tandem" << endl;
      return 1;
    }

  MassSpectrum spectrum_drange(spectrum_low_masses);
  FilterRescaleY(100).filter(spectrum_drange);
  if(!spectrum_drange.equals(sdynamic_range, precision))
    {
      cerr << "spectrum_drange() != tandem" << endl;
      return 1;
    }

  pappso_double parent_ion_mhplus =
    ((638.36934732588 - (MHPLUS * charge_pep15968)) * charge_pep15968) + MHPLUS;
  MzRange neutral_mass = MzRange(parent_ion_mhplus - MASSH2O,
                                 PrecisionFactory::getDaltonInstance(0.5));

  MassSpectrum spectrum_neutral(spectrum_drange);
  MassSpectrumFilterResampleRemoveMzRange(neutral_mass)
    .filter(spectrum_neutral);

  // Spectrum
  // spectrum_neutral(spectrum_drange.removeNeutral(pep15968.getPeptideSp(),
  // charge_pep15968, MASSH2O, DaltonPrecision(0.5)));
  if(!spectrum_neutral.equals(sremove_neutral, precision))
    {
      cerr << "spectrum_neutral() != tandem" << endl;
      return 1;
    }


  MassSpectrum spectrum_clean_isotopes(
    spectrum_neutral.massSpectrumFilter(pappso::FilterTandemRemoveC13()));
  cout << spectrum_neutral.size() << endl;
  cout << sclean_isotopes.size() << endl;
  cout << spectrum_clean_isotopes.size() << endl;
  if(!spectrum_clean_isotopes.equals(sclean_isotopes, precision))
    {
      cerr << "spectrum_clean_isotopes() != tandem" << endl;
      return 1;
      // spectrum_most_intense = std::move(sremove_small);
    }

  MassSpectrum spectrum_most_intense(spectrum_clean_isotopes);
  spectrum_most_intense.massSpectrumFilter(
    MassSpectrumFilterGreatestItensities(100));
  if(!spectrum_most_intense.equals(sremove_small, precision))
    {
      cerr << "spectrum_most_intense() != tandem" << endl;
      return 1;
      // spectrum_most_intense = std::move(sremove_small);
    }


  bool refine_spectrum_synthesis = true;
  // spectrum.debugPrintValues();
  XtandemHyperscore hyperscore15968(spectrum_most_intense,
                                    pep15968.makePeptideSp(),
                                    charge_pep15968,
                                    precision,
                                    ion_list,
                                    refine_spectrum_synthesis);
  cout << "peptide " << pep15968.getSequence().toStdString()
       << " hyperscore15968=" << hyperscore15968.getHyperscore() << endl;
  cout << "peptide " << pep15968.getSequence().toStdString()
       << " mz1=" << pep15968.getMz(1) << " mz2=" << pep15968.getMz(2) << endl;

  // Spectrum::getHyperscore  "b"  itmap->second  1   1
  //  Spectrum::getHyperscore  "y"  itmap->second  9   362880

  /*
  <group id="15968" mh="1275.731419" z="2" rt="PT2843.58S" expect="1.7e-04"
label="GRMZM5G815453_P01 P00874 Ribulose bisphosphate carboxylase large chain
Precursor..." type="model" sumI="6.08" maxI="111642" fI="1116.42" act="0" >
<protein expect="-191.8" id="15968.1" uid="49237" label="GRMZM5G815453_P01
P00874 Ribulose bisphosphate carboxylase large chain Precursor..." sumI="8.97" >
<note label="description">GRMZM5G815453_P01 P00874 Ribulose bisphosphate
carboxylase large chain Precursor (RuBisCO large subunit)(EC 4.1.1.39)
seq=translation; coord=Pt:56824..58323:1; parent_transcript=GRMZM5G815453_T01;
parent_gene=GRMZM5G815453</note> <file type="peptide"
URL="/gorgone/pappso/formation/TD/Database/Genome_Z_mays_5a.fasta"/> <peptide
start="1" end="483"> <domain id="15968.1.1" start="347" end="357"
expect="1.7e-04" mh="1275.7311" delta="0.0003" hyperscore="29.0"
nextscore="10.8" y_score="10.5" y_ions="8" b_score="3.8" b_ions="1" pre="EGER"
post="DDFI" seq="EITLGFVDLLR" missed_cleavages="0">
</domain>
</peptide>
*/
  return 0;
}
