/**
 * \file pappsomspp/pappsoexception.cpp
 * \date 10/3/2015
 * \author Olivier Langella
 * \brief exception handler
 */

/*******************************************************************************
 * Copyright (c) 2015 Olivier Langella <Olivier.Langella@moulon.inra.fr>.
 *
 * This file is part of the PAPPSOms++ library.
 *
 *     PAPPSOms++ is free software: you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation, either version 3 of the License, or
 *     (at your option) any later version.
 *
 *     PAPPSOms++ is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with PAPPSOms++.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Contributors:
 *     Olivier Langella <Olivier.Langella@moulon.inra.fr> - initial API and
 *implementation
 ******************************************************************************/


#pragma once

#include <exception>
#include <QString>
#include <QDebug>

namespace pappso
{
class PappsoException : public std::exception
{
  private:
  QString m_message; // Description of the error

  public:
  PappsoException(const QString &message) throw()
  {
    qDebug() << message;
    m_message = message;
  }


  virtual const QString &
  qwhat() const throw()
  {
    return m_message;
  }

  virtual const char *
  what() const throw() override
  {
    return m_message.toStdString().c_str();
  }

  virtual ~PappsoException() throw()
  {
  }
};
} // namespace pappso
