/**
 * \file pappsomspp/msrun/private/timsmsrunreaderms2.cpp
 * \date 10/09/2019
 * \author Olivier Langella
 * \brief MSrun file reader for native Bruker TimsTOF specialized for MS2
 * purpose
 */


/*******************************************************************************
 * Copyright (c) 2019 Olivier Langella <Olivier.Langella@u-psud.fr>.
 *
 * This file is part of the PAPPSOms++ library.
 *
 *     PAPPSOms++ is free software: you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation, either version 3 of the License, or
 *     (at your option) any later version.
 *
 *     PAPPSOms++ is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with PAPPSOms++.  If not, see <http://www.gnu.org/licenses/>.
 *
 ******************************************************************************/

#include "timsmsrunreaderms2.h"
#include "../../exception/exceptionnotimplemented.h"
#include <QDebug>

using namespace pappso;

TimsMsRunReaderMs2::TimsMsRunReaderMs2(MsRunIdCstSPtr &msrun_id_csp)
  : MsRunReader(msrun_id_csp)
{
  initialize();
}

TimsMsRunReaderMs2::~TimsMsRunReaderMs2()
{
  if(mpa_timsData != nullptr)
    {
      delete mpa_timsData;
    }
}

void
pappso::TimsMsRunReaderMs2::initialize()
{
  mpa_timsData = new TimsData(mcsp_msRunId.get()->getFileName());
}


bool
TimsMsRunReaderMs2::accept(const QString &file_name) const
{
  qDebug() << __FILE__ << " " << __FUNCTION__ << " " << __LINE__ << " "
           << file_name;
  return true;
}


pappso::MassSpectrumSPtr
TimsMsRunReaderMs2::massSpectrumSPtr(std::size_t spectrum_index)
{
  throw ExceptionNotImplemented(
    QObject::tr("Not yet implemented in TimsMsRunReaderMs2 %1.\n")
      .arg(__LINE__));
  return pappso::MassSpectrumSPtr();
}


pappso::MassSpectrumCstSPtr
TimsMsRunReaderMs2::massSpectrumCstSPtr(std::size_t spectrum_index)
{
  return mpa_timsData->getMassSpectrumCstSPtrByRawIndex(spectrum_index);
}


QualifiedMassSpectrum
TimsMsRunReaderMs2::qualifiedMassSpectrum(std::size_t spectrum_index,
                                          bool want_binary_data) const
{

  QualifiedMassSpectrum mass_spectrum =
    mpa_timsData->getQualifiedMassSpectrumByPrecursorId(spectrum_index,
                                                        want_binary_data);
  MassSpectrumId spectrum_id(mass_spectrum.getMassSpectrumId());
  spectrum_id.setMsRunId(getMsRunId());
  mass_spectrum.setMassSpectrumId(spectrum_id);
  qDebug() << __FILE__ << " " << __FUNCTION__ << " " << __LINE__ << " "
           << mass_spectrum.toString();

  qDebug() << __FILE__ << " " << __FUNCTION__ << " " << __LINE__ << " "
           << mass_spectrum.getMassSpectrumSPtr().get()->toString();
  return mass_spectrum;
}


void
TimsMsRunReaderMs2::readSpectrumCollection(
  SpectrumCollectionHandlerInterface &handler)
{
  throw ExceptionNotImplemented(
    QObject::tr("Not yet implemented in TimsMsRunReaderMs2 %1.\n")
      .arg(__LINE__));
}


std::size_t
TimsMsRunReaderMs2::spectrumListSize() const
{
  return mpa_timsData->getTotalNumberOfScans();
}


bool
TimsMsRunReaderMs2::hasScanNumbers() const
{
  return false;
}
