
/*******************************************************************************
 * Copyright (c) 2015 Olivier Langella <Olivier.Langella@moulon.inra.fr>.
 *
 * This file is part of the PAPPSOms++ library.
 *
 *     PAPPSOms++ is free software: you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation, either version 3 of the License, or
 *     (at your option) any later version.
 *
 *     PAPPSOms++ is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with PAPPSOms++.  If not, see <http://www.gnu.org/licenses/>.
 *
 ******************************************************************************/

#pragma once

#include <QIODevice>
#include <QFile>
#include <QTextStream>
#include "fastahandlerinterface.h"

namespace pappso
{
class FastaFileIndexer;
class FastaReader
{
  friend FastaFileIndexer;

  public:
  FastaReader(FastaHandlerInterface &handler);
  ~FastaReader();

  void parse(QFile &fastaFile);
  void parse(QIODevice *p_inputstream);

  protected:
  void parseOnlyOne(QTextStream &p_in);

  private:
  FastaHandlerInterface &m_handler;
};
} // namespace pappso
