
/*******************************************************************************
 * Copyright (c) 2018 Olivier Langella <Olivier.Langella@u-psud.fr>.
 *
 * This file is part of the PAPPSOms++ library.
 *
 *     PAPPSOms++ is free software: you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation, either version 3 of the License, or
 *     (at your option) any later version.
 *
 *     PAPPSOms++ is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with PAPPSOms++.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Contributors:
 *     Olivier Langella <Olivier.Langella@u-psud.fr> - initial API and
 *implementation
 ******************************************************************************/

#include <iostream>
#include <odsstream/odsdocreader.h>
#include <odsstream/odsdocwriter.h>

#include "config.h"
#include <QDebug>
#include <QFile>
#include <QtCore>
#include <pappsomspp/pappsoexception.h>
#include <pappsomspp/xicextractor/msrunxicextractorfactory.h>
//#include "common.h"

// make test ARGS="-V -I 18,18"

using namespace std;
using namespace pappso;

int main(int argc, char *argv[]) {
  // QCoreApplication a(argc, argv);

  qDebug() << "init test XIC extractor";
  cout << endl << "..:: Test XIC ::.." << endl;
  QTime timer;

  MsRunId msrun_id("msrun_test");
  //msrun_id.setFilename("/espace/20120906_balliau_extract_1_A01_urnb-1.mzXML");
  msrun_id.setFilename("/gorgone/pappso/data_extraction_pappso/mzXML/20120906_balliau_extract_1_A01_urnb-1.mzXML");
  pappso::MsRunXicExtractorFactory::getInstance().setTmpDir("/tmp");

  MassRange mass_range(600, Precision::getPpmInstance(10));
  // MassRange mass_range_b(600.2, Precision::getPpmInstance(10));

  MsRunXicExtractorSp extractor_pwiz =
      pappso::MsRunXicExtractorFactory::getInstance()
          .buildMsRunXicExtractorPwizSp(msrun_id);

  XicSp xic_pwiz = extractor_pwiz.get()->getXicSp(mass_range);

  cout << endl << "..:: XIC extractor pwiz is OK ::.." << endl;

  cout << endl << "building XicExtractorDiskSp .." << endl;
  timer.start();
  MsRunXicExtractorSp extractor_disk =
      pappso::MsRunXicExtractorFactory::getInstance()
          .buildMsRunXicExtractorDiskSp(msrun_id);
  cout << endl << "XicExtractorDiskSp built " << timer.elapsed()/1000 << " seconds" << endl;

  XicSp xic_disk = extractor_disk.get()->getXicSp(mass_range);

  if (*xic_pwiz != *xic_disk) {
    cerr << "*xic_pwiz != *xic_disk ERROR" << endl;
    return 1;
  }

  cout << endl << "..:: XIC extractor on disk is OK ::.." << endl;
  //return 0;

  cout << endl << "building XicExtractorDiskBufferSp .." << endl;
  timer.restart();
  MsRunXicExtractorSp extractor_buffer =
      pappso::MsRunXicExtractorFactory::getInstance()
          .buildMsRunXicExtractorDiskBufferSp(msrun_id);
  cout << endl << "XicExtractorDiskBufferSp built " << timer.elapsed()/1000 << " seconds" << endl;

  XicSp xic_buffer = extractor_buffer.get()->getXicSp(mass_range);

  if (*xic_pwiz != *xic_buffer) {
    cerr << "*xic_pwiz != *xic_buffer ERROR" << endl;
    return 1;
  }

  cout << endl << "..:: XIC extractor buffered on disk is OK ::.." << endl;

  return 0;
}
