#pragma once

#include <QDebug>
#include <pappsomspp/spectrum/spectrum.h>
#include <pappsomspp/msrun/msrunreaderfactory.h>

using namespace pappso;

Spectrum
readMgf(const QString &filename)
{
  MsRunId id(filename);
  id.setFilename(filename);
  MsRunReaderSp reader =
    MsRunReaderFactory::getInstance().buildPwizMsRunReaderSp(id);

  qDebug() << __FILE__ << " " << __FUNCTION__ << " " << __LINE__ << " "
           << reader->getSpectrumListSize();
  SpectrumSp spectrum_sp = reader->getSpectrumSp(1);
  qDebug() << __FILE__ << " " << __FUNCTION__ << " " << __LINE__ << " "
           << spectrum_sp.get()->size();
  spectrum_sp.get()->debugPrintValues();
  return *(spectrum_sp.get());
}
