/**
 * \file pappsomspp/xicextractor/private/msrunxicextractorpwiz.h
 * \date 07/05/2018
 * \author Olivier Langella
 * \brief simple proteowizard based XIC extractor
*/

/*******************************************************************************
* Copyright (c) 2018 Olivier Langella <Olivier.Langella@u-psud.fr>.
*
* This file is part of the PAPPSOms++ library.
*
*     PAPPSOms++ is free software: you can redistribute it and/or modify
*     it under the terms of the GNU General Public License as published by
*     the Free Software Foundation, either version 3 of the License, or
*     (at your option) any later version.
*
*     PAPPSOms++ is distributed in the hope that it will be useful,
*     but WITHOUT ANY WARRANTY; without even the implied warranty of
*     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*     GNU General Public License for more details.
*
*     You should have received a copy of the GNU General Public License
*     along with PAPPSOms++.  If not, see <http://www.gnu.org/licenses/>.
*
* Contributors:
*     Olivier Langella <Olivier.Langella@u-psud.fr> - initial API and implementation
******************************************************************************/

#include "../msrunxicextractor.h"
#include <pwiz/data/msdata/MSData.hpp>
#include <pwiz/data/msdata/MSDataFile.hpp>

#ifndef MSRUNXICEXTRACTORPWIZ_H
#define MSRUNXICEXTRACTORPWIZ_H

class MsRunXicExtractorFactory;

namespace pappso {
    
class MsRunXicExtractorPwiz: public MsRunXicExtractor
{
    friend MsRunXicExtractorFactory;
public:
    virtual ~MsRunXicExtractorPwiz();
    virtual XicSp getXicSp(const MassRange & mz_range, pappso::pappso_double rt_begin, pappso::pappso_double rt_end) override;
    virtual std::vector<XicSp> getXicSpList(const std::vector<MassRange> & mz_range_list) override;
    
protected:
    MsRunXicExtractorPwiz(const MsRunId & msrun_id);
    
    void getPwizMSDataFile();
    void prepareExtractor();
    
    virtual void getXicFromPwizMSDataFile(std::vector<Xic *> & xic_list, const std::vector<MassRange> & mass_range_list, pappso::pappso_double rt_begin, pappso::pappso_double rt_end);
protected :
    pwiz::msdata::MSDataFile * _m_p_msdatafile = nullptr;
};
}
#endif // MSRUNXICEXTRACTORPWIZ_H
