/**
 * \file pappsomspp/xicextractor/private/msrunxicextractordisk.h
 * \date 12/05/2018
 * \author Olivier Langella
 * \brief proteowizard based XIC extractor featuring disk cache
*/

/*******************************************************************************
* Copyright (c) 2018 Olivier Langella <Olivier.Langella@u-psud.fr>.
*
* This file is part of the PAPPSOms++ library.
*
*     PAPPSOms++ is free software: you can redistribute it and/or modify
*     it under the terms of the GNU General Public License as published by
*     the Free Software Foundation, either version 3 of the License, or
*     (at your option) any later version.
*
*     PAPPSOms++ is distributed in the hope that it will be useful,
*     but WITHOUT ANY WARRANTY; without even the implied warranty of
*     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*     GNU General Public License for more details.
*
*     You should have received a copy of the GNU General Public License
*     along with PAPPSOms++.  If not, see <http://www.gnu.org/licenses/>.
*
* Contributors:
*     Olivier Langella <Olivier.Langella@u-psud.fr> - initial API and implementation
******************************************************************************/

#include "../msrunxicextractor.h"
#include <pwiz/data/msdata/MSData.hpp>
#include <pwiz/data/msdata/MSDataFile.hpp>
#include "msrunslice.h"
#include <QTemporaryDir>
#include <deque>
#include <QMutex>

#ifndef MSRUNXICEXTRACTORDISK_H
#define MSRUNXICEXTRACTORDISK_H

class MsRunXicExtractorFactory;

namespace pappso {

class MsRunXicExtractorDisk: public MsRunXicExtractor
{
    friend MsRunXicExtractorFactory;
public:
    MsRunXicExtractorDisk(const MsRunXicExtractorDisk & other);
    virtual ~MsRunXicExtractorDisk();
    virtual XicSp getXicSp(const MassRange & mz_range, pappso::pappso_double rt_begin, pappso::pappso_double rt_end) override;
    virtual std::vector<XicSp> getXicSpList(const std::vector<MassRange> & mz_range_list) override;

protected:
    MsRunXicExtractorDisk(const MsRunId & msrun_id, const QDir & temporary_dir);

    void prepareExtractor();
    void getPwizMSDataFile();

    void serializeMsRun(pwiz::msdata::MSDataFile * p_msdatafile);
    
    virtual void storeSlices(std::map<unsigned int,Spectrum> & slice_vector, std::size_t ipos);
    void appendSliceOnDisk(unsigned int slice_number, Spectrum & spectrum, std::size_t ipos);
    
    std::vector<MsRunSliceSp> acquireSlices(const MassRange & mz_range);
    
    MsRunSliceSp unserializeSlice(unsigned int slice_number);
    
    virtual void endPwizRead() {};

protected:
    QString _m_temporary_directory;
    QTemporaryDir * _m_p_temporary_directory = nullptr;
    std::vector<pappso::pappso_double> _m_retention_time_list;

    pappso::pappso_double _max_mz = 0;
    pappso::pappso_double _min_mz = 5000;
    
    std::size_t _m_rt_size=0;
    
    std::deque<MsRunSliceSp> _m_msrun_slice_list_cache;
    
    QMutex _m_mutex;

};
}
#endif // MSRUNXICEXTRACTORDISK_H
