/**
 * \file pappsomspp/xicextractor/msrunxicextractorfactory.cpp
 * \date 07/05/2018
 * \author Olivier Langella
 * \brief factory to build XIC extractor on an MsRun file
 */

/*******************************************************************************
* Copyright (c) 2018 Olivier Langella <Olivier.Langella@u-psud.fr>.
*
* This file is part of the PAPPSOms++ library.
*
*     PAPPSOms++ is free software: you can redistribute it and/or modify
*     it under the terms of the GNU General Public License as published by
*     the Free Software Foundation, either version 3 of the License, or
*     (at your option) any later version.
*
*     PAPPSOms++ is distributed in the hope that it will be useful,
*     but WITHOUT ANY WARRANTY; without even the implied warranty of
*     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*     GNU General Public License for more details.
*
*     You should have received a copy of the GNU General Public License
*     along with PAPPSOms++.  If not, see <http://www.gnu.org/licenses/>.
*
* Contributors:
*     Olivier Langella <Olivier.Langella@u-psud.fr> - initial API and implementation
******************************************************************************/

#include "msrunxicextractorfactory.h"
#include "private/msrunxicextractorpwiz.h"
#include "private/msrunxicextractordisk.h"
#include "private/msrunxicextractordiskbuffer.h"

namespace pappso {


MsRunXicExtractorFactory MsRunXicExtractorFactory::_m_instance=MsRunXicExtractorFactory();

MsRunXicExtractorFactory& MsRunXicExtractorFactory::getInstance()
{
    return _m_instance;
}


MsRunXicExtractorFactory::MsRunXicExtractorFactory() {
}
MsRunXicExtractorFactory::~MsRunXicExtractorFactory() {
}

void MsRunXicExtractorFactory::setTmpDir(const QString & dir_name) {
    _tmp_dir_name = dir_name;
}
MsRunXicExtractorSp MsRunXicExtractorFactory::buildMsRunXicExtractorPwizSp(const MsRunId & msrun_id) const {
    std::shared_ptr<MsRunXicExtractorPwiz> msrun_xic_extractor_sp = std::make_shared<MsRunXicExtractorPwiz>(MsRunXicExtractorPwiz(msrun_id));
msrun_xic_extractor_sp.get()->prepareExtractor();
    return (msrun_xic_extractor_sp);
}

MsRunXicExtractorSp MsRunXicExtractorFactory::buildMsRunXicExtractorDiskSp(const MsRunId & msrun_id) const {
    std::shared_ptr<MsRunXicExtractorDisk> msrun_xic_extractor_sp = std::make_shared<MsRunXicExtractorDisk>(MsRunXicExtractorDisk(msrun_id, QDir(_tmp_dir_name)));

    msrun_xic_extractor_sp.get()->prepareExtractor();
    return (msrun_xic_extractor_sp);
}

MsRunXicExtractorSp MsRunXicExtractorFactory::buildMsRunXicExtractorDiskBufferSp(const MsRunId & msrun_id) const {
    std::shared_ptr<MsRunXicExtractorDiskBuffer> msrun_xic_extractor_sp = std::make_shared<MsRunXicExtractorDiskBuffer>(MsRunXicExtractorDiskBuffer(msrun_id, QDir(_tmp_dir_name)));
    msrun_xic_extractor_sp.get()->prepareExtractor();
    return (msrun_xic_extractor_sp);
}

}
