/**
 * \file pappsomspp/xicextractor/msrunxicextractor.cpp
 * \date 07/05/2018
 * \author Olivier Langella
 * \brief base interface to build XICs on an MsRun file
 */

/*******************************************************************************
* Copyright (c) 2018 Olivier Langella <Olivier.Langella@u-psud.fr>.
*
* This file is part of the PAPPSOms++ library.
*
*     PAPPSOms++ is free software: you can redistribute it and/or modify
*     it under the terms of the GNU General Public License as published by
*     the Free Software Foundation, either version 3 of the License, or
*     (at your option) any later version.
*
*     PAPPSOms++ is distributed in the hope that it will be useful,
*     but WITHOUT ANY WARRANTY; without even the implied warranty of
*     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*     GNU General Public License for more details.
*
*     You should have received a copy of the GNU General Public License
*     along with PAPPSOms++.  If not, see <http://www.gnu.org/licenses/>.
*
* Contributors:
*     Olivier Langella <Olivier.Langella@u-psud.fr> - initial API and implementation
******************************************************************************/

#include "msrunxicextractor.h"

namespace pappso {

MsRunXicExtractor::MsRunXicExtractor(const MsRunId & msrun_id):_m_msrun_id(msrun_id) {
}


MsRunXicExtractor::MsRunXicExtractor(const MsRunXicExtractor & other):_m_msrun_id(other._m_msrun_id) {
    _m_xic_extract_method = other._m_xic_extract_method;
}

MsRunXicExtractor::~MsRunXicExtractor() {
}

XicSp MsRunXicExtractor::getXicSp(const MassRange & mz_range) {
    return getXicSp(mz_range, 0, 100000000);
}

void MsRunXicExtractor::setXicExtractMethod(XicExtractMethod method) {
    _m_xic_extract_method = method;
}
const MsRunId & MsRunXicExtractor::getMsRunId() const {
    return _m_msrun_id;
}
}
