
/*******************************************************************************
 * Copyright (c) 2015 Olivier Langella <Olivier.Langella@moulon.inra.fr>.
 *
 * This file is part of the PAPPSOms++ library.
 *
 *     PAPPSOms++ is free software: you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation, either version 3 of the License, or
 *     (at your option) any later version.
 *
 *     PAPPSOms++ is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with PAPPSOms++.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Contributors:
 *     Olivier Langella <Olivier.Langella@moulon.inra.fr> - initial API and implementation
 ******************************************************************************/

#ifndef XICPEAK_H
#define XICPEAK_H

#include "xic.h"
#include "../types.h"

namespace pappso {


typedef std::shared_ptr<const XicPeak> XicPeakSp;

/** @/brief Xic Peak stores peak boudaries detected from a Xic
 * */
class XicPeak
{
public:
    XicPeak();
    XicPeak(const XicPeak& other);
    ~XicPeak();
    
    
    XicPeakSp makeXicPeakSp() const;
    
    XicElement & getMaxXicElement();
    const XicElement & getMaxXicElement() const {
        return _max;
    };
    void setMaxXicElement(const XicElement & max);

    XicElement & getLeftBoundary() ;
    const XicElement & getLeftBoundary() const {
        return _left;
    };
    void setLeftBoundary(const XicElement & left);

    XicElement & getRightBoundary();
    const XicElement & getRightBoundary() const;
    void setRightBoundary(const XicElement & right);
    pappso_double getArea() const;
    void setArea(pappso_double area);
    void integrateXicElement(const XicElement & previous, const XicElement & current);

    bool containsRt(pappso::pappso_double rt) const;


    bool operator ==(const XicPeak &other) const {
        return ((_area == other._area) && (_max == other._max)&& (_left == other._left)&& (_right == other._right));
    };

protected:

    pappso_double _area=0;


    XicElement _max;
    XicElement _left;
    XicElement _right;


};
}
#endif // XICPEAK_H
