/*
 * /*******************************************************************************
 * * Copyright (c) 2015 Olivier Langella <Olivier.Langella@moulon.inra.fr>.
 * *
 * * This file is part of MassChroqPRM.
 * *
 * *     MassChroqPRM is free software: you can redistribute it and/or modify
 * *     it under the terms of the GNU General Public License as published by
 * *     the Free Software Foundation, either version 3 of the License, or
 * *     (at your option) any later version.
 * *
 * *     MassChroqPRM is distributed in the hope that it will be useful,
 * *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 * *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * *     GNU General Public License for more details.
 * *
 * *     You should have received a copy of the GNU General Public License
 * *     along with MassChroqPRM.  If not, see <http://www.gnu.org/licenses/>.
 * *
 * * Contributors:
 * *     Olivier Langella <Olivier.Langella@moulon.inra.fr> - initial API and implementation
 * ******************************************************************************/

#ifndef QUALIFIEDXIC_H
#define QUALIFIEDXIC_H


#include <vector>
#include <memory>
#include "xic.h"
#include "../msrun/msrunid.h"
#include "../mass_range.h"
#include "../peptide/peptide.h"
#include "../psm/peakionmatch.h"

using namespace std;
namespace pappso {


class QualifiedXic;
typedef std::shared_ptr<Xic> QualifiedXicSp;


class QualifiedXic
{
public:
    QualifiedXic(const MsRunId & msrun_id, mz mz, PrecisionP precision);
    virtual ~QualifiedXic();
    QualifiedXic(const QualifiedXic & toCopy);


    mz getMz() const {
        return _mz;
    };
    const XicSp getXicSp() const {
      return _xic_sp;
    }
    
    const NoConstXicSp & getNoConstXicSp() const {
      return _xic_sp;
    }

private:

    const MsRunId _msrun_id;
    mz _mz;
    PrecisionP _precision;
    
    NoConstXicSp _xic_sp;

};
}
#endif // QUALIFIEDXIC_H
