/*
 * /*******************************************************************************
 * * Copyright (c) 2015 Olivier Langella <Olivier.Langella@moulon.inra.fr>.
 * *
 * * This file is part of MassChroqPRM.
 * *
 * *     MassChroqPRM is free software: you can redistribute it and/or modify
 * *     it under the terms of the GNU General Public License as published by
 * *     the Free Software Foundation, either version 3 of the License, or
 * *     (at your option) any later version.
 * *
 * *     MassChroqPRM is distributed in the hope that it will be useful,
 * *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 * *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * *     GNU General Public License for more details.
 * *
 * *     You should have received a copy of the GNU General Public License
 * *     along with MassChroqPRM.  If not, see <http://www.gnu.org/licenses/>.
 * *
 * * Contributors:
 * *     Olivier Langella <Olivier.Langella@moulon.inra.fr> - initial API and implementation
 * ******************************************************************************/

#include <QDebug>
#include "qualifiedxic.h"
#include <vector>

namespace pappso {



QualifiedXic::QualifiedXic(const MsRunId & msrun_id, mz mz, PrecisionP precision)
: _msrun_id(msrun_id), _mz(mz), _precision(precision), _xic_sp(Xic().makeNoConstXicSp())
{
  qDebug() << "QualifiedXic::QualifiedXic begin";
}

QualifiedXic::~QualifiedXic()
{
}


QualifiedXic::QualifiedXic(const QualifiedXic & toCopy): _msrun_id(toCopy._msrun_id),_mz(toCopy._mz), _precision(toCopy._precision), _xic_sp(toCopy._xic_sp) {
qDebug() << "QualifiedXic::QualifiedXic copy begin";
}

}
