
/*******************************************************************************
 * Copyright (c) 2015 Olivier Langella <Olivier.Langella@moulon.inra.fr>.
 *
 * This file is part of the PAPPSOms++ library.
 *
 *     PAPPSOms++ is free software: you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation, either version 3 of the License, or
 *     (at your option) any later version.
 *
 *     PAPPSOms++ is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with PAPPSOms++.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Contributors:
 *     Olivier Langella <Olivier.Langella@moulon.inra.fr> - initial API and implementation
 ******************************************************************************/
#ifndef XICFILTERSMOOTHING_H
#define XICFILTERSMOOTHING_H

#include "./xicfilterinterface.h"

namespace pappso {
class XicFilterSmoothing: public XicFilterInterface
{
public:
    XicFilterSmoothing();
    ~XicFilterSmoothing();
    void setSmoothingHalfEdgeWindows(unsigned int smoothing_half_window_length) {
        _smoothing_half_window_length=smoothing_half_window_length;
    };
    unsigned int getSmoothingHalfEdgeWindows () const {
        return _smoothing_half_window_length;
    };
   
protected :
    void filterInternal (const Xic & xic, Xic & newxic) const override;

private :
    unsigned int _smoothing_half_window_length=0;
};
}
#endif // XICFILTERSMOOTHING_H
