
/*******************************************************************************
 * Copyright (c) 2015 Olivier Langella <Olivier.Langella@moulon.inra.fr>.
 *
 * This file is part of the PAPPSOms++ library.
 *
 *     PAPPSOms++ is free software: you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation, either version 3 of the License, or
 *     (at your option) any later version.
 *
 *     PAPPSOms++ is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with PAPPSOms++.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Contributors:
 *     Olivier Langella <Olivier.Langella@moulon.inra.fr> - initial API and implementation
 ******************************************************************************/
#include "xicfiltermax.h"



namespace pappso {
pappso_double
get_max(std::vector<XicElement>::const_iterator beginit, std::vector<XicElement>::const_iterator endit) {
    return std::max_element(beginit, endit)->intensity;
}


pappso_double
get_min(std::vector<XicElement>::const_iterator beginit, std::vector<XicElement>::const_iterator endit) {
    return std::min_element(beginit, endit)->intensity;
}

void XicFilterMax::filterInternal (const Xic & xic, Xic & newxic) const {
    xic.newXicByApplyingWindowsOperation(_half_edge_windows,&get_max, newxic);
}

void XicFilterMin::filterInternal (const Xic & xic, Xic & newxic) const {
    xic.newXicByApplyingWindowsOperation(_half_edge_windows,&get_max, newxic);
}

void XicFilterMaxMin::filterInternal (const Xic & xic, Xic & newxic) const {
    Xic xic_min;
    xic.newXicByApplyingWindowsOperation(_half_edge_windows,&get_min, xic_min);
    xic_min.newXicByApplyingWindowsOperation(_half_edge_windows,&get_max, newxic);
}

void XicFilterMinMax::filterInternal (const Xic & xic, Xic & newxic) const {
    Xic xic_max;
    xic.newXicByApplyingWindowsOperation(_half_edge_windows,&get_max,xic_max);
    xic_max.newXicByApplyingWindowsOperation(_half_edge_windows,&get_min,newxic);
}

}
