/**
 * \file pappsomspp/widget/precision/precisionwidget.h
 * \date 5/1/2018
 * \author Olivier Langella
 * \brief edit presicion in ppm or dalton
 */


/*******************************************************************************
* Copyright (c) 2018 Olivier Langella <Olivier.Langella@u-psud.fr>.
*
* This file is part of the PAPPSOms++ library.
*
*     PAPPSOms++ is free software: you can redistribute it and/or modify
*     it under the terms of the GNU General Public License as published by
*     the Free Software Foundation, either version 3 of the License, or
*     (at your option) any later version.
*
*     PAPPSOms++ is distributed in the hope that it will be useful,
*     but WITHOUT ANY WARRANTY; without even the implied warranty of
*     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*     GNU General Public License for more details.
*
*     You should have received a copy of the GNU General Public License
*     along with PAPPSOms++.  If not, see <http://www.gnu.org/licenses/>.
*
* Contributors:
*     Olivier Langella <Olivier.Langella@u-psud.fr> - initial API and implementation
******************************************************************************/

#ifndef PRECISIONWIDGET_H
#define PRECISIONWIDGET_H

#include <QWidget>
#include <QComboBox>
#include <QDoubleSpinBox>
#include "../../mass_range.h"

namespace pappso {
class PrecisionWidget: public QWidget {
    Q_OBJECT
public:
    PrecisionWidget(QWidget *parent = 0);
    ~PrecisionWidget();
    
    void setPrecision(pappso::PrecisionP precision);
    const pappso::PrecisionP & getPrecision() const;
    
signals:
    void precisionChanged(pappso::PrecisionP precision) const;
private:
    Q_SLOT void setCurrentIndex(int);
    Q_SLOT void setPpmValueChanged(double);
    Q_SLOT void setDaltonValueChanged(double);
private:
    QComboBox * _p_unit_box;
    QDoubleSpinBox * _p_ppm_value;
    QDoubleSpinBox * _p_dalton_value;
    pappso::PrecisionP _precision_dalton;
    pappso::PrecisionP _precision_ppm;
    int _old_index;
    

};
}
#endif // PRECISIONWIDGET_H
