
/*******************************************************************************
 * Copyright (c) 2015 Olivier Langella <Olivier.Langella@moulon.inra.fr>.
 *
 * This file is part of the PAPPSOms++ library.
 *
 *     PAPPSOms++ is free software: you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation, either version 3 of the License, or
 *     (at your option) any later version.
 *
 *     PAPPSOms++ is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with PAPPSOms++.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Contributors:
 *     Olivier Langella <Olivier.Langella@moulon.inra.fr> - initial API and implementation
 ******************************************************************************/
#ifndef QUALIFIEDSPECTRUM_H
#define QUALIFIEDSPECTRUM_H

#include "spectrum.h"
#include "spectrumid.h"

namespace pappso {
class QualifiedSpectrum
{
public:
    QualifiedSpectrum(const SpectrumId & spectrum_id);
    QualifiedSpectrum(const QualifiedSpectrum & other);
    QualifiedSpectrum();
    ~QualifiedSpectrum();

    const SpectrumId & getSpectrumId() const ;
    void setSpectrumId(const SpectrumId & original_spectrum_id) ;

    void setOriginalSpectrumSp(SpectrumSp & original_spectrum_sp) ;
    SpectrumSp getOriginalSpectrumSp() const ;
    void setPrecursorCharge(unsigned int precursor_charge) ;
    unsigned int getPrecursorCharge() const ;
    void setPrecursorMz(mz precursor_mz) ;
    mz getPrecursorMz() const ;
    void setMsLevel(unsigned int ms_level);
    unsigned int getMsLevel() const ;
    void setRtInSeconds(pappso_double rt_in_seconds) ;
    pappso_double getRtInSeconds() const ;
    
    void setPrecursorScanNum(unsigned long precursor_scan_num);
    unsigned long getPrecursorScanNum() const;
    
    
    void setPrecursorIntensity(pappso_double intensity) ;
    pappso_double getPrecursorIntensity() const ;

private :
    SpectrumId _spectrum_id;

    SpectrumSp _original_spectrum_sp;

    unsigned int _precursor_charge=0;
    mz _precursor_mz=0;
    pappso_double _precursor_intensity=0;
    unsigned int _ms_level=0;

    pappso_double _rt_in_seconds=0;
    
    unsigned long _precursor_scan_num=0;


};
}
#endif // QUALIFIEDSPECTRUM_H
